import { LinterOptions, LintResult } from "./LinterContext.js";
import { ProjectGraph } from "@ui5/project";
import type { AbstractReader } from "@ui5/fs";
import { UI5LintConfigType } from "../utils/ConfigManager.js";
export declare function lintProject({ rootDir, filePatterns, ignorePatterns, coverage, details, configPath, ui5Config, noConfig, }: LinterOptions): Promise<LintResult[]>;
export declare function lintFile({ rootDir, filePatterns, ignorePatterns, namespace, coverage, details, configPath, noConfig, }: LinterOptions): Promise<LintResult[]>;
declare function getProjectGraph(rootDir: string, ui5Config?: string | object): Promise<ProjectGraph>;
export declare function resolveReader({ patterns, resourceReader, inverseResult, patternsMatch, relFsBasePath, virBasePath, relFsBasePathTest, virBasePathTest, }: {
    patterns: string[];
    resourceReader: AbstractReader;
    inverseResult?: boolean;
    patternsMatch: Set<string>;
    relFsBasePath: string;
    virBasePath: string;
    relFsBasePathTest?: string;
    virBasePathTest?: string;
}): AbstractReader;
export declare function mergeIgnorePatterns(options: LinterOptions, config: UI5LintConfigType): string[];
export declare const __localFunctions__: {
    getProjectGraph: typeof getProjectGraph;
} | undefined;
export {};
