import ts from "typescript";
import LinterContext, { CoverageInfo, ResourcePath } from "../LinterContext.js";
import { MESSAGE } from "../messages.js";
import { MessageArgs } from "../MessageArgs.js";
interface ReporterCoverageInfo extends CoverageInfo {
    node: ts.Node;
}
export default class SourceFileReporter {
    #private;
    constructor(context: LinterContext, resourcePath: ResourcePath, sourceFile: ts.SourceFile, sourceMap: string | undefined);
    addMessage<M extends MESSAGE>(id: M, args: MessageArgs[M], node: ts.Node): void;
    addMessage<M extends MESSAGE>(id: M, node: ts.Node): void;
    addCoverageInfo({ node, message, messageDetails, category }: ReporterCoverageInfo): void;
    deduplicateMessages(): void;
}
export {};
