/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.compiled.verification;

import io.moderne.compiled.internal.JavaTypeClassWriter;
import io.moderne.compiled.table.ABITraces;
import io.moderne.compiled.verification.VerificationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.TraceClassVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.search.FindMissingTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markup;
import org.openrewrite.marker.RecipesThatMadeChanges;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.scheduling.WorkingDirectoryExecutionContextView;

public final class VerifyCompilation
extends Recipe {
    private final transient ABITraces traces = new ABITraces(this);
    @Option(displayName="Trace", description="Trace the ABIs of dependencies of files being verified.", required=false)
    private final @Nullable Boolean trace;

    public String getDisplayName() {
        return "Verify compilation";
    }

    public String getDescription() {
        return "This is a task that runs after another recipe to verify that the changes made by that recipe would result in a successful compilation.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                if (!cu.getMarkers().findFirst(RecipesThatMadeChanges.class).isPresent()) {
                    return cu;
                }
                WorkingDirectoryExecutionContextView workingDir = WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx);
                Path classesDir = workingDir.getWorkingDirectory().resolve(cu.getId().toString());
                if (!classesDir.toFile().mkdirs()) {
                    return (J.CompilationUnit)Markup.warn((Tree)cu, (Throwable)new IOException("Unable to create directory " + classesDir));
                }
                this.writeClassesThatAreUsed(cu, classesDir, ctx);
                String printedAfterChange = cu.printAll();
                SourceFile recompiled = (SourceFile)JavaParser.fromJavaVersion().logCompilationWarningsAndErrors(true).classpath(Collections.singleton(classesDir)).build().parse(new String[]{printedAfterChange}).findFirst().orElseThrow(() -> new IllegalStateException("No compilation unit found"));
                return this.findErroneous(recompiled).map(this.withOriginalIdAndMarkers(cu)).orElseGet(() -> this.findMissingTypes(recompiled, ctx).map(this.withOriginalIdAndMarkers(cu)).orElse(cu));
            }

            private Optional<J.CompilationUnit> findErroneous(SourceFile recompiled) {
                SourceFile verified = (SourceFile)new JavaIsoVisitor<Integer>(){

                    public J.Erroneous visitErroneous(J.Erroneous erroneous, Integer p) {
                        String message = erroneous.getText();
                        if (StringUtils.isBlank((String)message)) {
                            message = "compile error";
                        }
                        return (J.Erroneous)Markup.warn((Tree)erroneous, (Throwable)new VerificationException(message));
                    }
                }.visitNonNull((Tree)recompiled, (Object)0);
                if (verified != recompiled) {
                    return Optional.of((J.CompilationUnit)verified);
                }
                return Optional.empty();
            }

            private Optional<J.CompilationUnit> findMissingTypes(SourceFile recompiled, ExecutionContext ctx) {
                SourceFile verified = (SourceFile)new FindMissingTypes().getVisitor().visitNonNull((Tree)recompiled, (Object)ctx);
                if (recompiled != verified) {
                    return Optional.of((J.CompilationUnit)verified).map(this.convertSearchMarkersToErrorMarkup("does not exist"));
                }
                return Optional.empty();
            }

            private Function<J.CompilationUnit, J.CompilationUnit> withOriginalIdAndMarkers(J.CompilationUnit cu) {
                return c -> c.withId(cu.getId()).withMarkers(cu.getMarkers());
            }

            private Function<J.CompilationUnit, J.CompilationUnit> convertSearchMarkersToErrorMarkup(final String message) {
                return c -> (J.CompilationUnit)new JavaIsoVisitor<Integer>(){

                    public Marker visitMarker(Marker marker, Integer integer) {
                        return marker instanceof SearchResult ? new Markup.Warn(Tree.randomId(), (Throwable)new VerificationException(message)) : marker;
                    }
                }.visitNonNull((Tree)c, (Object)0);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void writeClassesThatAreUsed(J.CompilationUnit cu, Path classesDir, ExecutionContext ctx) {
                CopyOnWriteArraySet<JavaType.FullyQualified> usedButNotDefinedByMe = new CopyOnWriteArraySet<JavaType.FullyQualified>();
                cu.getTypesInUse().getTypesInUse().forEach(t -> {
                    if (t instanceof JavaType.Class) {
                        this.maybeAddUsedClass((Set<JavaType.FullyQualified>)usedButNotDefinedByMe, (JavaType)t);
                    }
                });
                int lastSize = 0;
                while (lastSize < usedButNotDefinedByMe.size()) {
                    for (JavaType.FullyQualified usedClass : usedButNotDefinedByMe) {
                        this.maybeAddUsedClass(usedButNotDefinedByMe, (JavaType)usedClass.getSupertype());
                        for (JavaType.FullyQualified anInterface : usedClass.getInterfaces()) {
                            this.maybeAddUsedClass(usedButNotDefinedByMe, (JavaType)anInterface);
                        }
                    }
                    lastSize = usedButNotDefinedByMe.size();
                }
                cu.getClasses().forEach(c -> usedButNotDefinedByMe.remove(c.getType()));
                IdentityHashMap<JavaType.FullyQualified, Collection> usedWithInnerClasses = new IdentityHashMap<JavaType.FullyQualified, Collection>();
                for (JavaType.FullyQualified usedClass : usedButNotDefinedByMe) {
                    usedWithInnerClasses.putIfAbsent(usedClass, new ArrayList());
                    if (usedClass.getOwningClass() == null) continue;
                    usedWithInnerClasses.computeIfAbsent(usedClass.getOwningClass(), k -> new ArrayList()).add(usedClass);
                }
                JavaTypeClassWriter writer = new JavaTypeClassWriter();
                for (Map.Entry usedClassAndInnerClasses : usedWithInnerClasses.entrySet()) {
                    JavaType.FullyQualified usedClass = (JavaType.FullyQualified)usedClassAndInnerClasses.getKey();
                    Path packageDir = classesDir.resolve(Arrays.stream(usedClass.getPackageName().split("\\.")).map(x$0 -> Paths.get(x$0, new String[0])).reduce(Path::resolve).orElse(Paths.get("", new String[0])));
                    if (!Files.exists(packageDir, new LinkOption[0]) && !packageDir.toFile().mkdirs()) {
                        throw new IOException("Unable to create package directory");
                    }
                    try {
                        byte[] abi = writer.toABI(usedClass, ((Collection)usedClassAndInnerClasses.getValue()).toArray(new JavaType.FullyQualified[0]));
                        if (Boolean.TRUE.equals(VerifyCompilation.this.trace)) {
                            this.traceAbi(cu, ctx, usedClass, abi);
                        }
                        Files.write(packageDir.resolve(usedClass.getClassName().replace('.', '$') + ".class"), abi, new OpenOption[0]);
                    }
                    catch (Throwable t2) {
                        StringWriter sw = new StringWriter();
                        t2.printStackTrace(new PrintWriter(sw));
                        throw new IllegalStateException("Unable to write ABI bytecodes for " + usedClass.getFullyQualifiedName() + ". Caused by:\n" + sw, t2);
                        return;
                    }
                }
            }

            private void maybeAddUsedClass(Set<JavaType.FullyQualified> usedButNotDefinedByMe, @Nullable JavaType t) {
                if (t != null && !((JavaType.FullyQualified)t).getPackageName().startsWith("java.")) {
                    if (t instanceof JavaType.Parameterized) {
                        this.maybeAddUsedClass(usedButNotDefinedByMe, (JavaType)((JavaType.Parameterized)t).getType());
                    } else {
                        usedButNotDefinedByMe.add((JavaType.FullyQualified)t);
                    }
                }
            }

            private void traceAbi(J.CompilationUnit cu, ExecutionContext ctx, JavaType.FullyQualified usedClass, byte[] abi) {
                try {
                    ClassReader classReader = new ClassReader((InputStream)new ByteArrayInputStream(abi));
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    classReader.accept((ClassVisitor)new TraceClassVisitor(pw), 0);
                    String abiTrace = sw.toString();
                    VerifyCompilation.this.traces.insertRow(ctx, new ABITraces.Row(cu.getSourcePath().toString(), usedClass.getFullyQualifiedName(), abiTrace));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    @Generated
    public VerifyCompilation(@Nullable Boolean trace) {
        this.trace = trace;
    }

    @Generated
    public ABITraces getTraces() {
        return this.traces;
    }

    @Generated
    public @Nullable Boolean getTrace() {
        return this.trace;
    }

    @Generated
    public String toString() {
        return "VerifyCompilation(traces=" + (Object)((Object)this.getTraces()) + ", trace=" + this.getTrace() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerifyCompilation)) {
            return false;
        }
        VerifyCompilation other = (VerifyCompilation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$trace = this.getTrace();
        Boolean other$trace = other.getTrace();
        return !(this$trace == null ? other$trace != null : !((Object)this$trace).equals(other$trace));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VerifyCompilation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $trace = this.getTrace();
        result = result * 59 + ($trace == null ? 43 : ((Object)$trace).hashCode());
        return result;
    }
}

