/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.compiled.internal.signature;

import io.moderne.compiled.internal.signature.ClassTypeSignature;
import io.moderne.compiled.internal.signature.FormalTypeParameter;
import io.moderne.compiled.internal.signature.FormalTypeParameters;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.tree.JavaType;

public final class ClassSignature {
    private final @Nullable FormalTypeParameters formalTypeParameters;
    private final ClassTypeSignature superclassSignature;
    private final @Nullable List<ClassTypeSignature> superinterfaceSignatures;

    public static ClassSignature fromJavaType(JavaType.FullyQualified fq) {
        ArrayList<ClassTypeSignature> superinterfaceSignatures = null;
        if (!fq.getInterfaces().isEmpty()) {
            superinterfaceSignatures = new ArrayList<ClassTypeSignature>();
            for (JavaType.FullyQualified anInterface : fq.getInterfaces()) {
                superinterfaceSignatures.add(ClassTypeSignature.fromJavaType(anInterface));
            }
        }
        FormalTypeParameters ftp = null;
        List typeParameters = fq.getTypeParameters();
        if (!typeParameters.isEmpty()) {
            ArrayList<FormalTypeParameter> params = new ArrayList<FormalTypeParameter>();
            for (JavaType typeParameter : typeParameters) {
                if (typeParameter instanceof JavaType.GenericTypeVariable) {
                    JavaType.GenericTypeVariable gtv = (JavaType.GenericTypeVariable)typeParameter;
                    params.add(FormalTypeParameter.fromJavaType(gtv));
                    continue;
                }
                throw new IllegalStateException("Unexpected type parameter of type " + typeParameter.getClass().getSimpleName());
            }
            ftp = new FormalTypeParameters(params);
        }
        return new ClassSignature(ftp, ClassTypeSignature.fromJavaType(fq.getSupertype()), superinterfaceSignatures);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.formalTypeParameters != null) {
            sb.append(this.formalTypeParameters);
        }
        sb.append(this.superclassSignature);
        if (this.superinterfaceSignatures != null) {
            for (ClassTypeSignature superinterfaceSignature : this.superinterfaceSignatures) {
                sb.append(superinterfaceSignature);
            }
        }
        return sb.toString();
    }

    @Generated
    public ClassSignature(@Nullable FormalTypeParameters formalTypeParameters, ClassTypeSignature superclassSignature, @Nullable List<ClassTypeSignature> superinterfaceSignatures) {
        this.formalTypeParameters = formalTypeParameters;
        this.superclassSignature = superclassSignature;
        this.superinterfaceSignatures = superinterfaceSignatures;
    }

    @Generated
    public @Nullable FormalTypeParameters getFormalTypeParameters() {
        return this.formalTypeParameters;
    }

    @Generated
    public ClassTypeSignature getSuperclassSignature() {
        return this.superclassSignature;
    }

    @Generated
    public @Nullable List<ClassTypeSignature> getSuperinterfaceSignatures() {
        return this.superinterfaceSignatures;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassSignature)) {
            return false;
        }
        ClassSignature other = (ClassSignature)o;
        FormalTypeParameters this$formalTypeParameters = this.getFormalTypeParameters();
        FormalTypeParameters other$formalTypeParameters = other.getFormalTypeParameters();
        if (this$formalTypeParameters == null ? other$formalTypeParameters != null : !this$formalTypeParameters.equals(other$formalTypeParameters)) {
            return false;
        }
        ClassTypeSignature this$superclassSignature = this.getSuperclassSignature();
        ClassTypeSignature other$superclassSignature = other.getSuperclassSignature();
        if (this$superclassSignature == null ? other$superclassSignature != null : !this$superclassSignature.equals(other$superclassSignature)) {
            return false;
        }
        List<ClassTypeSignature> this$superinterfaceSignatures = this.getSuperinterfaceSignatures();
        List<ClassTypeSignature> other$superinterfaceSignatures = other.getSuperinterfaceSignatures();
        return !(this$superinterfaceSignatures == null ? other$superinterfaceSignatures != null : !((Object)this$superinterfaceSignatures).equals(other$superinterfaceSignatures));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FormalTypeParameters $formalTypeParameters = this.getFormalTypeParameters();
        result = result * 59 + ($formalTypeParameters == null ? 43 : $formalTypeParameters.hashCode());
        ClassTypeSignature $superclassSignature = this.getSuperclassSignature();
        result = result * 59 + ($superclassSignature == null ? 43 : $superclassSignature.hashCode());
        List<ClassTypeSignature> $superinterfaceSignatures = this.getSuperinterfaceSignatures();
        result = result * 59 + ($superinterfaceSignatures == null ? 43 : ((Object)$superinterfaceSignatures).hashCode());
        return result;
    }
}

