/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.compiled.internal.signature;

import io.moderne.compiled.internal.signature.FormalTypeParameter;
import io.moderne.compiled.internal.signature.FormalTypeParameters;
import io.moderne.compiled.internal.signature.ReturnType;
import io.moderne.compiled.internal.signature.ThrowsSignature;
import io.moderne.compiled.internal.signature.TypeSignature;
import io.moderne.compiled.internal.signature.VoidDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.tree.JavaType;

public final class MethodTypeSignature {
    private final String name;
    private final @Nullable FormalTypeParameters formalTypeParameters;
    private final @Nullable List<TypeSignature> argumentSignatures;
    private final ReturnType returnType;
    private final @Nullable List<ThrowsSignature> throwsSignature;

    public static MethodTypeSignature fromJavaType(JavaType.Method method) {
        List paramTypes = method.getParameterTypes();
        ArrayList<TypeSignature> paramTypeSignatures = null;
        Map<String, FormalTypeParameter> formalTypeParams = null;
        if (!paramTypes.isEmpty()) {
            paramTypeSignatures = new ArrayList<TypeSignature>(paramTypes.size());
            for (JavaType parameterType : paramTypes) {
                TypeSignature paramTypeSignature = TypeSignature.fromJavaType(parameterType);
                paramTypeSignatures.add(Objects.requireNonNull(paramTypeSignature));
                formalTypeParams = MethodTypeSignature.maybeAddFormalTypeParam(method, parameterType, formalTypeParams);
            }
        }
        formalTypeParams = MethodTypeSignature.maybeAddFormalTypeParam(method, method.getReturnType(), formalTypeParams);
        for (JavaType thrown : method.getThrownExceptions()) {
            formalTypeParams = MethodTypeSignature.maybeAddFormalTypeParam(method, thrown, formalTypeParams);
        }
        return new MethodTypeSignature(method.getName(), formalTypeParams == null ? null : new FormalTypeParameters(formalTypeParams.values()), paramTypeSignatures, method.isConstructor() ? VoidDescriptor.getInstance() : Objects.requireNonNull(ReturnType.fromJavaType(method.getReturnType())), ThrowsSignature.fromJavaType(method.getThrownExceptions()));
    }

    private static @Nullable Map<String, FormalTypeParameter> maybeAddFormalTypeParam(final JavaType.Method method, JavaType type, @Nullable Map<String, FormalTypeParameter> formalTypeParams) {
        final AtomicReference<Map<String, FormalTypeParameter>> after = new AtomicReference<Map<String, FormalTypeParameter>>();
        if (formalTypeParams != null) {
            after.set(formalTypeParams);
        }
        new JavaTypeVisitor<Integer>(){
            final Set<JavaType> typeIdentity = Collections.newSetFromMap(new IdentityHashMap(3));

            public @Nullable JavaType visit(@Nullable JavaType javaType, Integer integer) {
                if (javaType != null && this.typeIdentity.add(javaType) && !(javaType instanceof JavaType.Class)) {
                    return super.visit(javaType, (Object)integer);
                }
                return javaType;
            }

            public JavaType visitGenericTypeVariable(JavaType.GenericTypeVariable gtv, Integer integer) {
                if (!("?".equals(gtv.getName()) || gtv.getBounds().isEmpty() && !method.getDeclaredFormalTypeNames().contains(gtv.getName()))) {
                    if (after.get() == null) {
                        after.set(new LinkedHashMap());
                    }
                    ((Map)after.get()).put(gtv.getName(), FormalTypeParameter.fromJavaType(gtv));
                }
                return super.visitGenericTypeVariable(gtv, (Object)0);
            }
        }.visit(type, Integer.valueOf(0));
        return (Map)after.get();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.formalTypeParameters != null) {
            sb.append(this.formalTypeParameters);
        }
        sb.append("(");
        if (this.argumentSignatures != null) {
            for (TypeSignature type : this.argumentSignatures) {
                sb.append(type);
            }
        }
        sb.append(")");
        sb.append(this.returnType);
        if (this.throwsSignature != null) {
            for (ThrowsSignature thrown : this.throwsSignature) {
                sb.append(thrown);
            }
        }
        return sb.toString();
    }

    @Generated
    public MethodTypeSignature(String name, @Nullable FormalTypeParameters formalTypeParameters, @Nullable List<TypeSignature> argumentSignatures, ReturnType returnType, @Nullable List<ThrowsSignature> throwsSignature) {
        this.name = name;
        this.formalTypeParameters = formalTypeParameters;
        this.argumentSignatures = argumentSignatures;
        this.returnType = returnType;
        this.throwsSignature = throwsSignature;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public @Nullable FormalTypeParameters getFormalTypeParameters() {
        return this.formalTypeParameters;
    }

    @Generated
    public @Nullable List<TypeSignature> getArgumentSignatures() {
        return this.argumentSignatures;
    }

    @Generated
    public ReturnType getReturnType() {
        return this.returnType;
    }

    @Generated
    public @Nullable List<ThrowsSignature> getThrowsSignature() {
        return this.throwsSignature;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodTypeSignature)) {
            return false;
        }
        MethodTypeSignature other = (MethodTypeSignature)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        FormalTypeParameters this$formalTypeParameters = this.getFormalTypeParameters();
        FormalTypeParameters other$formalTypeParameters = other.getFormalTypeParameters();
        if (this$formalTypeParameters == null ? other$formalTypeParameters != null : !this$formalTypeParameters.equals(other$formalTypeParameters)) {
            return false;
        }
        List<TypeSignature> this$argumentSignatures = this.getArgumentSignatures();
        List<TypeSignature> other$argumentSignatures = other.getArgumentSignatures();
        if (this$argumentSignatures == null ? other$argumentSignatures != null : !((Object)this$argumentSignatures).equals(other$argumentSignatures)) {
            return false;
        }
        ReturnType this$returnType = this.getReturnType();
        ReturnType other$returnType = other.getReturnType();
        if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
            return false;
        }
        List<ThrowsSignature> this$throwsSignature = this.getThrowsSignature();
        List<ThrowsSignature> other$throwsSignature = other.getThrowsSignature();
        return !(this$throwsSignature == null ? other$throwsSignature != null : !((Object)this$throwsSignature).equals(other$throwsSignature));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        FormalTypeParameters $formalTypeParameters = this.getFormalTypeParameters();
        result = result * 59 + ($formalTypeParameters == null ? 43 : $formalTypeParameters.hashCode());
        List<TypeSignature> $argumentSignatures = this.getArgumentSignatures();
        result = result * 59 + ($argumentSignatures == null ? 43 : ((Object)$argumentSignatures).hashCode());
        ReturnType $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        List<ThrowsSignature> $throwsSignature = this.getThrowsSignature();
        result = result * 59 + ($throwsSignature == null ? 43 : ((Object)$throwsSignature).hashCode());
        return result;
    }
}

