/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.knowledge;

import io.moderne.knowledge.KnowledgeBaseExecutionContextView;
import io.moderne.knowledge.MethodSemantics;
import io.moderne.knowledge.model.ClassComprehension;
import io.moderne.knowledge.model.ClassDescription;
import io.moderne.knowledge.model.CodeReadingAssistant;
import io.moderne.knowledge.model.LanguageModel;
import io.moderne.knowledge.model.MethodDescription;
import io.moderne.knowledge.model.Timed;
import io.moderne.knowledge.table.ClassDescriptions;
import io.moderne.knowledge.table.MethodDescriptions;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.HasSourceSet;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;

public final class ComprehendCode
extends Recipe {
    private final transient ClassDescriptions classDescriptions = new ClassDescriptions(this);
    private final transient MethodDescriptions methodDescriptions = new MethodDescriptions(this);

    public String getDisplayName() {
        return "Comprehend code";
    }

    public String getDescription() {
        return "Use LLMs to add inferred knowledge to the code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not((TreeVisitor)new HasSourceSet("test").getVisitor()), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final CodeReadingAssistant assistant = new CodeReadingAssistant(LanguageModel.GEMINI);
            final String classComprehensionKey = "classComprehension";

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                ClassComprehension comprehension = new ClassComprehension(this.getCursor());
                this.getCursor().putMessage("classComprehension", (Object)comprehension);
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                Timed<ClassDescription> timed = this.assistant.describeClass(comprehension);
                ClassDescription classDescription = timed.value();
                List<ClassDescription.ArchitecturalPattern> patternsInUse = classDescription.architecturalPatterns();
                ComprehendCode.this.classDescriptions.insertRow(ctx, new ClassDescriptions.Row(classDecl.getType().getFullyQualifiedName(), timed.latency().getNano() / 1000000, classDescription.description(), !patternsInUse.isEmpty() ? patternsInUse.get(0).getNameOrShortDescription() : null, patternsInUse.size() > 1 ? patternsInUse.get(1).getNameOrShortDescription() : null, patternsInUse.size() > 2 ? patternsInUse.get(2).getNameOrShortDescription() : null));
                KnowledgeBaseExecutionContextView.view(ctx).getClassDescriptions().put(classDecl.getType(), classDescription);
                return cd;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (method.getMethodType().hasFlags(new Flag[]{Flag.Private}) || method.getMethodType() == null || MethodSemantics.isBoilerplate(this.getCursor())) {
                    return method;
                }
                Timed<MethodDescription> timed = this.assistant.describeMethod(this.getCursor());
                MethodDescription methodDescription = timed.value();
                List<MethodDescription.Technique> librariesOrTechniquesInUse = methodDescription.techniquesInUse();
                ComprehendCode.this.methodDescriptions.insertRow(ctx, new MethodDescriptions.Row(method.getMethodType().getDeclaringType().getFullyQualifiedName(), method.getMethodType().toString(), timed.latency().getNano() / 1000000, methodDescription.description(), methodDescription.descriptionOfReturnedValue(), !librariesOrTechniquesInUse.isEmpty() ? librariesOrTechniquesInUse.get(0).nameOrShortDescription() : null, librariesOrTechniquesInUse.size() > 1 ? librariesOrTechniquesInUse.get(1).nameOrShortDescription() : null, librariesOrTechniquesInUse.size() > 2 ? librariesOrTechniquesInUse.get(2).nameOrShortDescription() : null));
                ClassComprehension classComprehension = (ClassComprehension)this.getCursor().getNearestMessage("classComprehension");
                classComprehension.getMethodDescriptions().put(method, methodDescription);
                return super.visitMethodDeclaration(method, (Object)ctx);
            }
        });
    }

    @Generated
    public ComprehendCode() {
    }

    @Generated
    public ClassDescriptions getClassDescriptions() {
        return this.classDescriptions;
    }

    @Generated
    public MethodDescriptions getMethodDescriptions() {
        return this.methodDescriptions;
    }

    @Generated
    public String toString() {
        return "ComprehendCode(classDescriptions=" + this.getClassDescriptions() + ", methodDescriptions=" + this.getMethodDescriptions() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComprehendCode)) {
            return false;
        }
        ComprehendCode other = (ComprehendCode)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComprehendCode;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

