/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.knowledge.docs;

import io.moderne.knowledge.ComprehendCode;
import io.moderne.knowledge.KnowledgeBaseExecutionContextView;
import io.moderne.knowledge.docs.ReadmeChat;
import io.moderne.knowledge.model.ClassDescription;
import io.moderne.knowledge.model.LanguageModel;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.text.PlainTextParser;

public final class UpdateReadme
extends ScanningRecipe<AtomicBoolean> {
    @Option(displayName="Prompt", description="Prompt that guides the LLM on how you want the README structured.", required=false)
    private final @Nullable String prompt;

    public String getDisplayName() {
        return "Update README";
    }

    public String getDescription() {
        return "Generate a README file for the project, containing information about the project inferred from its knowledge graph.";
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(false);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean readmeExists) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)tree;
                if (PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"README.md")) {
                    readmeExists.set(true);
                }
                new ComprehendCode().getVisitor().visit(tree, (Object)ctx);
                this.stopAfterPreVisit();
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(AtomicBoolean readmeExists, ExecutionContext ctx) {
        String readme;
        if (!readmeExists.get() && (readme = this.writeReadme("No README exists yet.", ctx)) != null) {
            return PlainTextParser.builder().build().parse(new String[]{readme}).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean acc) {
        return Preconditions.check((Recipe)this.isReadme(), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                String readme = UpdateReadme.this.writeReadme(tree.print(this.getCursor()), ctx);
                this.stopAfterPreVisit();
                if (readme == null) {
                    return tree;
                }
                return ((SourceFile)PlainTextParser.builder().build().parse(new String[]{readme}).findFirst().orElseThrow()).withId(tree.getId()).withMarkers(tree.getMarkers());
            }
        });
    }

    private @Nullable String writeReadme(String existingReadme, ExecutionContext ctx) {
        Map<JavaType.FullyQualified, ClassDescription> classDescriptions = KnowledgeBaseExecutionContextView.view(ctx).getClassDescriptions();
        StringJoiner classDescriptionTable = new StringJoiner("\n", "| Class Name                      | Description                  |\n|---------------------------------|------------------------------|\n", "");
        for (Map.Entry<JavaType.FullyQualified, ClassDescription> classDescription : classDescriptions.entrySet()) {
            classDescriptionTable.add("| " + classDescription.getKey() + " | " + classDescription.getValue().description() + " |");
        }
        ReadmeChat assistant = LanguageModel.GEMINI.getAssistant(ReadmeChat.class);
        String readme = (String)LanguageModel.GEMINI.getRateLimiter().executeSupplier(() -> assistant.updateReadme(this.prompt == null ? "" : this.prompt, classDescriptionTable.toString(), existingReadme).trim());
        return readme.equalsIgnoreCase("<<DO NOT UPDATE>>") ? null : readme;
    }

    private FindSourceFiles isReadme() {
        return new FindSourceFiles("README.md");
    }

    @Generated
    public UpdateReadme(@Nullable String prompt) {
        this.prompt = prompt;
    }

    @Generated
    public @Nullable String getPrompt() {
        return this.prompt;
    }

    @Generated
    public String toString() {
        return "UpdateReadme(prompt=" + this.getPrompt() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateReadme)) {
            return false;
        }
        UpdateReadme other = (UpdateReadme)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        return !(this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpdateReadme;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        return result;
    }
}

