/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.knowledge.model;

import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.service.AiServices;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.moderne.knowledge.model.ClassComprehension;
import io.moderne.knowledge.model.ClassDescription;
import io.moderne.knowledge.model.CodeReadingChat;
import io.moderne.knowledge.model.LanguageModel;
import io.moderne.knowledge.model.MethodDescription;
import io.moderne.knowledge.model.Timed;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class CodeReadingAssistant {
    private final AiServices<CodeReadingChat> assistant;
    private final RateLimiter rateLimiter;

    public CodeReadingAssistant(LanguageModel model) {
        this.assistant = model.getAiServices(CodeReadingChat.class);
        this.rateLimiter = model.getRateLimiter();
    }

    public Timed<MethodDescription> describeMethod(Cursor methodCursor) {
        assert (methodCursor.getValue() instanceof J.MethodDeclaration);
        return (Timed)this.rateLimiter.executeSupplier(() -> {
            String code = ((J.MethodDeclaration)methodCursor.getValue()).printTrimmed(methodCursor);
            TypesInUse.FindTypesInUse findTypesInUse = new TypesInUse.FindTypesInUse();
            findTypesInUse.visitNonNull((Tree)methodCursor.getValue(), (Object)0, methodCursor.getParentOrThrow());
            String typesInUse = findTypesInUse.getTypes().stream().map(TypeUtils::asFullyQualified).filter(Objects::nonNull).map(JavaType.FullyQualified::getFullyQualifiedName).filter(n -> !n.startsWith("java.")).collect(Collectors.joining("\n* ", "* ", ""));
            return Timed.record(() -> ((CodeReadingChat)this.assistant.tools(new Object[]{new DependenciesInUse(methodCursor)}).build()).describeMethod(code, typesInUse.equals("* ") ? "No other types used." : typesInUse));
        });
    }

    public Timed<ClassDescription> describeClass(ClassComprehension comprehension) {
        return (Timed)this.rateLimiter.executeSupplier(() -> {
            String pseudoCode = comprehension.getPseudoCode();
            return Timed.record(() -> ((CodeReadingChat)this.assistant.build()).describeClass(pseudoCode));
        });
    }

    private JavaSourceSet getJavaSourceSet(Cursor cursor) {
        SourceFile sourceSet = (SourceFile)cursor.firstEnclosingOrThrow(SourceFile.class);
        return (JavaSourceSet)sourceSet.getMarkers().findFirst(JavaSourceSet.class).orElseThrow();
    }

    class DependenciesInUse {
        final Cursor cursor;

        @Tool(value={"Finds the version of a library dependency available to a piece of code."})
        @Nullable String libraryVersion(@P(value="Maven group ID") String groupName, @P(value="Maven artifact ID") String artifactName) {
            Set gavs = CodeReadingAssistant.this.getJavaSourceSet(this.cursor).getGavToTypes().keySet();
            return gavs.stream().filter(gav -> gav.startsWith(groupName + ":" + artifactName + ":")).findFirst().orElse("I don't know.");
        }

        @Generated
        public DependenciesInUse(Cursor cursor) {
            this.cursor = cursor;
        }
    }
}

