/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.knowledge.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class ClassDescriptions
extends DataTable<Row> {
    public ClassDescriptions(Recipe recipe) {
        super(recipe, "Class descriptions written by an LLM", "The inferred knowledge about classes in the codebase, as provided by an LLM.");
    }

    public static final class Row {
        @Column(displayName="Class name", description="The fully qualified name of the class")
        private final String className;
        @Column(displayName="Time to infer", description="The time taken by the LLM to infer the knowledge, in milliseconds.")
        private final long timeToInfer;
        @Column(displayName="Description", description="The description of the inferred knowledge, as provided by the LLM.")
        private final String description;
        @Column(displayName="Pattern in use 1", description="An architectural pattern in use in the class.")
        private final @Nullable String pattern1;
        @Column(displayName="Pattern in use 2", description="An architectural pattern in use in the class.")
        private final @Nullable String pattern2;
        @Column(displayName="Pattern in use 3", description="An architectural pattern in use in the class.")
        private final @Nullable String pattern3;

        @Generated
        public Row(String className, long timeToInfer, String description, @Nullable String pattern1, @Nullable String pattern2, @Nullable String pattern3) {
            this.className = className;
            this.timeToInfer = timeToInfer;
            this.description = description;
            this.pattern1 = pattern1;
            this.pattern2 = pattern2;
            this.pattern3 = pattern3;
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public long getTimeToInfer() {
            return this.timeToInfer;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public @Nullable String getPattern1() {
            return this.pattern1;
        }

        @Generated
        public @Nullable String getPattern2() {
            return this.pattern2;
        }

        @Generated
        public @Nullable String getPattern3() {
            return this.pattern3;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getTimeToInfer() != other.getTimeToInfer()) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$pattern1 = this.getPattern1();
            String other$pattern1 = other.getPattern1();
            if (this$pattern1 == null ? other$pattern1 != null : !this$pattern1.equals(other$pattern1)) {
                return false;
            }
            String this$pattern2 = this.getPattern2();
            String other$pattern2 = other.getPattern2();
            if (this$pattern2 == null ? other$pattern2 != null : !this$pattern2.equals(other$pattern2)) {
                return false;
            }
            String this$pattern3 = this.getPattern3();
            String other$pattern3 = other.getPattern3();
            return !(this$pattern3 == null ? other$pattern3 != null : !this$pattern3.equals(other$pattern3));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timeToInfer = this.getTimeToInfer();
            result = result * 59 + (int)($timeToInfer >>> 32 ^ $timeToInfer);
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $pattern1 = this.getPattern1();
            result = result * 59 + ($pattern1 == null ? 43 : $pattern1.hashCode());
            String $pattern2 = this.getPattern2();
            result = result * 59 + ($pattern2 == null ? 43 : $pattern2.hashCode());
            String $pattern3 = this.getPattern3();
            result = result * 59 + ($pattern3 == null ? 43 : $pattern3.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClassDescriptions.Row(className=" + this.getClassName() + ", timeToInfer=" + this.getTimeToInfer() + ", description=" + this.getDescription() + ", pattern1=" + this.getPattern1() + ", pattern2=" + this.getPattern2() + ", pattern3=" + this.getPattern3() + ")";
        }
    }
}

