/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.knowledge;

import io.moderne.knowledge.KnowledgeBaseExecutionContextView;
import io.moderne.knowledge.MethodSemantics;
import io.moderne.knowledge.model.ClassComprehension;
import io.moderne.knowledge.model.ClassDescription;
import io.moderne.knowledge.model.CodeReadingAssistant;
import io.moderne.knowledge.model.LanguageModel;
import io.moderne.knowledge.model.MethodDescription;
import io.moderne.knowledge.model.Timed;
import io.moderne.knowledge.resources.LSTInsight;
import io.moderne.knowledge.table.ClassDescriptions;
import io.moderne.knowledge.table.MethodDescriptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.HasSourceSet;
import org.openrewrite.java.testing.search.FindUnitTests;
import org.openrewrite.java.testing.search.UnitTest;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;

public class ComprehendCode
extends Recipe {
    final int MAX_NUM_UNIT_TESTS = 3;
    transient ClassDescriptions classDescriptions = new ClassDescriptions(this);
    transient MethodDescriptions methodDescriptions = new MethodDescriptions(this);
    Map<String, FindUnitTests.AccumulatorValue> unitTestAndTheirMethods = new HashMap<String, FindUnitTests.AccumulatorValue>();

    public ComprehendCode(FindUnitTests.Accumulator acc) {
        this.unitTestAndTheirMethods = acc.getUnitTestsByKey();
    }

    public ComprehendCode() {
    }

    public String getDisplayName() {
        return "Comprehend code";
    }

    public String getDescription() {
        return "Use LLMs to add inferred knowledge to the code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not((TreeVisitor)new HasSourceSet("test").getVisitor()), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final CodeReadingAssistant assistant = new CodeReadingAssistant(LanguageModel.GEMINI);
            final String classComprehensionKey = "classComprehension";

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                ClassComprehension comprehension = new ClassComprehension(this.getCursor());
                this.getCursor().putMessage("classComprehension", (Object)comprehension);
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                Timed<ClassDescription> timed = this.assistant.describeClass(comprehension);
                ClassDescription classDescription = timed.value();
                List<ClassDescription.ArchitecturalPattern> patternsInUse = classDescription.architecturalPatterns();
                ComprehendCode.this.classDescriptions.insertRow(ctx, new ClassDescriptions.Row(classDecl.getType().getFullyQualifiedName(), timed.latency().getNano() / 1000000, classDescription.description(), classDescription.responsibility(), !patternsInUse.isEmpty() ? patternsInUse.get(0).nameOrShortDescription() : null, patternsInUse.size() > 1 ? patternsInUse.get(1).nameOrShortDescription() : null, patternsInUse.size() > 2 ? patternsInUse.get(2).nameOrShortDescription() : null));
                KnowledgeBaseExecutionContextView.view(ctx).getClassDescriptions().put(classDecl.getType(), classDescription);
                return cd;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (method.getMethodType().hasFlags(new Flag[]{Flag.Private}) || method.getMethodType() == null || MethodSemantics.isBoilerplate(this.getCursor())) {
                    return method;
                }
                Cursor cursor = this.getCursor();
                Map<String, Integer> apiExamples = new LSTInsight.Tools(cursor).findExamplesOfAPI();
                String formattedAPIExamples = ComprehendCode.this.formatTopAPIExamples(apiExamples);
                ArrayList<String> examplesInUnitTest = new ArrayList<String>();
                for (Map.Entry<String, FindUnitTests.AccumulatorValue> entry : ComprehendCode.this.unitTestAndTheirMethods.entrySet()) {
                    String key = entry.getKey();
                    FindUnitTests.AccumulatorValue value = entry.getValue();
                    Set methodInvocations = value.getMethodInvocations();
                    UnitTest test = value.getUnitTest();
                    for (J.MethodInvocation methodInvocation : methodInvocations) {
                        if (!methodInvocation.getSimpleName().equals(method.getSimpleName()) || !methodInvocation.getMethodType().getDeclaringType().equals(method.getMethodType().getDeclaringType())) continue;
                        examplesInUnitTest.add(test.getUnitTest());
                    }
                }
                String formattedUnitExamples = examplesInUnitTest.stream().limit(3L).collect(Collectors.joining("\nUnitTests: ", "\n ", ""));
                Timed<MethodDescription> timed = this.assistant.describeMethod(cursor, formattedAPIExamples, formattedUnitExamples);
                MethodDescription methodDescription = timed.value();
                List<MethodDescription.Technique> librariesOrTechniquesInUse = methodDescription.techniquesInUse();
                ComprehendCode.this.methodDescriptions.insertRow(ctx, new MethodDescriptions.Row(method.getMethodType().getDeclaringType().getFullyQualifiedName(), method.getMethodType().toString(), timed.latency().getNano() / 1000000, methodDescription.description(), methodDescription.descriptionOfReturnedValue(), !librariesOrTechniquesInUse.isEmpty() ? librariesOrTechniquesInUse.get(0).nameOrShortDescription() : null, librariesOrTechniquesInUse.size() > 1 ? librariesOrTechniquesInUse.get(1).nameOrShortDescription() : null, librariesOrTechniquesInUse.size() > 2 ? librariesOrTechniquesInUse.get(2).nameOrShortDescription() : null, !apiExamples.isEmpty() ? formattedAPIExamples : null, !examplesInUnitTest.isEmpty() ? formattedUnitExamples : null));
                ClassComprehension classComprehension = (ClassComprehension)this.getCursor().getNearestMessage("classComprehension");
                classComprehension.getMethodDescriptions().put(method, methodDescription);
                return super.visitMethodDeclaration(method, (Object)ctx);
            }
        });
    }

    private String formatTopAPIExamples(Map<String, Integer> examples) {
        if (examples.isEmpty()) {
            return "No examples found.";
        }
        return examples.entrySet().stream().sorted((entry1, entry2) -> ((Integer)entry2.getValue()).compareTo((Integer)entry1.getValue())).limit(3L).map(entry -> (String)entry.getKey() + " : " + String.valueOf(entry.getValue()) + " occurrence" + ((Integer)entry.getValue() > 1 ? "s" : "")).collect(Collectors.joining("\n* ", "* ", ""));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComprehendCode)) {
            return false;
        }
        ComprehendCode other = (ComprehendCode)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.MAX_NUM_UNIT_TESTS != other.MAX_NUM_UNIT_TESTS) {
            return false;
        }
        Map<String, FindUnitTests.AccumulatorValue> this$unitTestAndTheirMethods = this.unitTestAndTheirMethods;
        Map<String, FindUnitTests.AccumulatorValue> other$unitTestAndTheirMethods = other.unitTestAndTheirMethods;
        return !(this$unitTestAndTheirMethods == null ? other$unitTestAndTheirMethods != null : !((Object)this$unitTestAndTheirMethods).equals(other$unitTestAndTheirMethods));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComprehendCode;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.MAX_NUM_UNIT_TESTS;
        Map<String, FindUnitTests.AccumulatorValue> $unitTestAndTheirMethods = this.unitTestAndTheirMethods;
        result = result * 59 + ($unitTestAndTheirMethods == null ? 43 : ((Object)$unitTestAndTheirMethods).hashCode());
        return result;
    }
}

