/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.knowledge.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class MethodDescriptions
extends DataTable<Row> {
    public MethodDescriptions(Recipe recipe) {
        super(recipe, "Method descriptions written by an LLM", "The inferred knowledge about methods in the codebase, as provided by an LLM.");
    }

    public static final class Row {
        @Column(displayName="Class name", description="The fully qualified name of the class")
        private final String className;
        @Column(displayName="Method signature", description="The code element at which the knowledge is inferred.")
        private final String signature;
        @Column(displayName="Time to infer", description="The time taken by the LLM to infer the knowledge, in milliseconds.")
        private final long timeToInfer;
        @Column(displayName="Description", description="The description of the inferred knowledge, as provided by the LLM.")
        private final String description;
        @Column(displayName="Return type description", description="What is contained in the returned type.")
        private final String descriptionOfReturnedValue;
        @Column(displayName="Technology in use 1", description="A technique in use in the method.")
        private final @Nullable String technique1;
        @Column(displayName="Technology in use 2", description="A technique in use in the method.")
        private final @Nullable String technique2;
        @Column(displayName="Technology in use 3", description="A technique in use in the method.")
        private final @Nullable String technique3;
        @Column(displayName="Examples", description="API examples of the methods in the codebase with the number of occurrences.")
        private final @Nullable String examplesOfApi;
        @Column(displayName="Examples of Unit Tests", description="Examples of the method declaration being used in the unit test.")
        private final String examplesOfApiInUnitTests;

        @Generated
        public Row(String className, String signature, long timeToInfer, String description, String descriptionOfReturnedValue, @Nullable String technique1, @Nullable String technique2, @Nullable String technique3, @Nullable String examplesOfApi, String examplesOfApiInUnitTests) {
            this.className = className;
            this.signature = signature;
            this.timeToInfer = timeToInfer;
            this.description = description;
            this.descriptionOfReturnedValue = descriptionOfReturnedValue;
            this.technique1 = technique1;
            this.technique2 = technique2;
            this.technique3 = technique3;
            this.examplesOfApi = examplesOfApi;
            this.examplesOfApiInUnitTests = examplesOfApiInUnitTests;
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public String getSignature() {
            return this.signature;
        }

        @Generated
        public long getTimeToInfer() {
            return this.timeToInfer;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getDescriptionOfReturnedValue() {
            return this.descriptionOfReturnedValue;
        }

        @Generated
        public @Nullable String getTechnique1() {
            return this.technique1;
        }

        @Generated
        public @Nullable String getTechnique2() {
            return this.technique2;
        }

        @Generated
        public @Nullable String getTechnique3() {
            return this.technique3;
        }

        @Generated
        public @Nullable String getExamplesOfApi() {
            return this.examplesOfApi;
        }

        @Generated
        public String getExamplesOfApiInUnitTests() {
            return this.examplesOfApiInUnitTests;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getTimeToInfer() != other.getTimeToInfer()) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$descriptionOfReturnedValue = this.getDescriptionOfReturnedValue();
            String other$descriptionOfReturnedValue = other.getDescriptionOfReturnedValue();
            if (this$descriptionOfReturnedValue == null ? other$descriptionOfReturnedValue != null : !this$descriptionOfReturnedValue.equals(other$descriptionOfReturnedValue)) {
                return false;
            }
            String this$technique1 = this.getTechnique1();
            String other$technique1 = other.getTechnique1();
            if (this$technique1 == null ? other$technique1 != null : !this$technique1.equals(other$technique1)) {
                return false;
            }
            String this$technique2 = this.getTechnique2();
            String other$technique2 = other.getTechnique2();
            if (this$technique2 == null ? other$technique2 != null : !this$technique2.equals(other$technique2)) {
                return false;
            }
            String this$technique3 = this.getTechnique3();
            String other$technique3 = other.getTechnique3();
            if (this$technique3 == null ? other$technique3 != null : !this$technique3.equals(other$technique3)) {
                return false;
            }
            String this$examplesOfApi = this.getExamplesOfApi();
            String other$examplesOfApi = other.getExamplesOfApi();
            if (this$examplesOfApi == null ? other$examplesOfApi != null : !this$examplesOfApi.equals(other$examplesOfApi)) {
                return false;
            }
            String this$examplesOfApiInUnitTests = this.getExamplesOfApiInUnitTests();
            String other$examplesOfApiInUnitTests = other.getExamplesOfApiInUnitTests();
            return !(this$examplesOfApiInUnitTests == null ? other$examplesOfApiInUnitTests != null : !this$examplesOfApiInUnitTests.equals(other$examplesOfApiInUnitTests));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timeToInfer = this.getTimeToInfer();
            result = result * 59 + (int)($timeToInfer >>> 32 ^ $timeToInfer);
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $descriptionOfReturnedValue = this.getDescriptionOfReturnedValue();
            result = result * 59 + ($descriptionOfReturnedValue == null ? 43 : $descriptionOfReturnedValue.hashCode());
            String $technique1 = this.getTechnique1();
            result = result * 59 + ($technique1 == null ? 43 : $technique1.hashCode());
            String $technique2 = this.getTechnique2();
            result = result * 59 + ($technique2 == null ? 43 : $technique2.hashCode());
            String $technique3 = this.getTechnique3();
            result = result * 59 + ($technique3 == null ? 43 : $technique3.hashCode());
            String $examplesOfApi = this.getExamplesOfApi();
            result = result * 59 + ($examplesOfApi == null ? 43 : $examplesOfApi.hashCode());
            String $examplesOfApiInUnitTests = this.getExamplesOfApiInUnitTests();
            result = result * 59 + ($examplesOfApiInUnitTests == null ? 43 : $examplesOfApiInUnitTests.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MethodDescriptions.Row(className=" + this.getClassName() + ", signature=" + this.getSignature() + ", timeToInfer=" + this.getTimeToInfer() + ", description=" + this.getDescription() + ", descriptionOfReturnedValue=" + this.getDescriptionOfReturnedValue() + ", technique1=" + this.getTechnique1() + ", technique2=" + this.getTechnique2() + ", technique3=" + this.getTechnique3() + ", examplesOfApi=" + this.getExamplesOfApi() + ", examplesOfApiInUnitTests=" + this.getExamplesOfApiInUnitTests() + ")";
        }
    }
}

