/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.knowledge.model;

import dev.langchain4j.service.AiServices;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.moderne.knowledge.model.ClassComprehension;
import io.moderne.knowledge.model.ClassDescription;
import io.moderne.knowledge.model.CodeReadingChat;
import io.moderne.knowledge.model.LanguageModel;
import io.moderne.knowledge.model.MethodDescription;
import io.moderne.knowledge.model.Timed;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class CodeReadingAssistant {
    private final AiServices<CodeReadingChat> assistant;
    private final RateLimiter rateLimiter;

    public CodeReadingAssistant(LanguageModel model) {
        this.assistant = model.getAiServices(CodeReadingChat.class);
        this.rateLimiter = model.getRateLimiter();
    }

    public Timed<MethodDescription> describeMethod(Cursor methodCursor, String apiExamples, String unitTestExamples) {
        assert (methodCursor.getValue() instanceof J.MethodDeclaration);
        return (Timed)this.rateLimiter.executeSupplier(() -> {
            String code = ((J.MethodDeclaration)methodCursor.getValue()).printTrimmed(methodCursor);
            TypesInUse.FindTypesInUse findTypesInUse = new TypesInUse.FindTypesInUse();
            findTypesInUse.visitNonNull((Tree)methodCursor.getValue(), (Object)0, methodCursor.getParentOrThrow());
            String typesInUse = findTypesInUse.getTypes().stream().map(TypeUtils::asFullyQualified).filter(Objects::nonNull).map(JavaType.FullyQualified::getFullyQualifiedName).filter(n -> !n.startsWith("java.")).collect(Collectors.joining("\n* ", "* ", ""));
            return Timed.record(() -> ((CodeReadingChat)this.assistant.build()).describeMethod(code, typesInUse.equals("* ") ? "No other types used." : typesInUse, apiExamples, unitTestExamples));
        });
    }

    public Timed<ClassDescription> describeClass(ClassComprehension comprehension) {
        return (Timed)this.rateLimiter.executeSupplier(() -> {
            String pseudoCode = comprehension.getPseudoCode();
            return Timed.record(() -> ((CodeReadingChat)this.assistant.build()).describeClass(pseudoCode));
        });
    }
}

