/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.moddy;

import dev.langchain4j.service.AiServices;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.moderne.knowledge.model.LanguageModel;
import io.moderne.moddy.RecipeChat;
import io.moderne.moddy.SuggestedRecipeDescriptor;
import org.openrewrite.rewrite.Recipe;

public class RecipeAssistant {
    private final AiServices<RecipeChat> assistant;
    private final RateLimiter rateLimiter;

    public RecipeAssistant(LanguageModel model) {
        this.assistant = model.getAiServices(RecipeChat.class);
        this.rateLimiter = model.getRateLimiter();
    }

    public Recipe improveRecipeDescriptor(Recipe recipe) {
        return (Recipe)this.rateLimiter.executeSupplier(() -> {
            SuggestedRecipeDescriptor suggested = ((RecipeChat)this.assistant.build()).improveRecipeDescriptor(recipe.getDisplayName(), recipe.getDescription(), recipe.getTree().printTrimmed(recipe.getCursor()));
            return recipe.withDisplayName(suggested.displayName()).withDescription(suggested.description());
        });
    }
}

