/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.knowledge;

import org.openrewrite.Cursor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

class MethodSemantics {
    MethodSemantics() {
    }

    public static boolean isBoilerplate(Cursor methodCursor) {
        J.MethodDeclaration method = (J.MethodDeclaration)methodCursor.getValue();
        String name = method.getSimpleName();
        if (method.isConstructor()) {
            return true;
        }
        if (name.startsWith("get") && MethodSemantics.classHasField(methodCursor, name.substring(3)) || name.startsWith("set") && MethodSemantics.classHasField(methodCursor, name.substring(3)) || name.startsWith("is") && MethodSemantics.classHasField(methodCursor, name.substring(2))) {
            return true;
        }
        return "equals".equals(name) || "hashCode".equals(name) || "toString".equals(name);
    }

    public static boolean classHasField(Cursor cursor, String name) {
        J.ClassDeclaration classDeclaration = (J.ClassDeclaration)cursor.firstEnclosingOrThrow(J.ClassDeclaration.class);
        for (Statement statement : classDeclaration.getBody().getStatements()) {
            if (!(statement instanceof J.VariableDeclarations)) continue;
            J.VariableDeclarations field = (J.VariableDeclarations)statement;
            for (J.VariableDeclarations.NamedVariable namedVariable : field.getVariables()) {
                if (!namedVariable.getSimpleName().equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }
}

