/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.knowledge.model;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.googleai.GoogleAiGeminiChatModel;
import dev.langchain4j.model.mistralai.MistralAiChatModel;
import dev.langchain4j.model.mistralai.MistralAiChatModelName;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.service.AiServices;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import java.time.Duration;
import java.util.Arrays;
import java.util.stream.Collectors;
import lombok.Generated;

public enum LanguageModel {
    AZURE_OPENAI(100, Duration.ofMinutes(1L)),
    GEMINI(2000, Duration.ofMinutes(1L)),
    OPENAI(3, Duration.ofMinutes(1L)),
    MISTRAL(5, Duration.ofSeconds(1L)),
    LLAMA(10000, Duration.ofSeconds(1L));

    private static final RateLimiterRegistry rateLimiterRegistry;
    private final int requestsPerPeriod;
    private final Duration period;

    public RateLimiter getRateLimiter() {
        return rateLimiterRegistry.rateLimiter(this.name(), this.name());
    }

    public <C> AiServices<C> getAiServices(Class<C> chatClass) {
        GoogleAiGeminiChatModel llm = switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> throw new UnsupportedOperationException("Implement me!");
            case 1 -> GoogleAiGeminiChatModel.builder().apiKey("AIzaSyASVf16yZhYaw5RY0vn0lA7gPFlX0Bpm-s").modelName("gemini-2.5-flash").build();
            case 2 -> OpenAiChatModel.builder().apiKey(this.failMessage()).modelName("gpt-4o-mini").build();
            case 3 -> MistralAiChatModel.builder().apiKey(this.failMessage()).modelName(MistralAiChatModelName.MISTRAL_LARGE_LATEST).build();
            case 4 -> OllamaChatModel.builder().baseUrl("http://localhost:11434").modelName("llama3.3:70b-instruct-q2_K").build();
        };
        return AiServices.builder(chatClass).chatLanguageModel((ChatLanguageModel)llm);
    }

    private String failMessage() {
        return "Please set the API key here, found in api-keys.properties at the root of the repository";
    }

    public <C> C getAssistant(Class<C> chatClass) {
        return (C)this.getAiServices(chatClass).build();
    }

    private static RateLimiterConfig requestsPerPeriodConfig(int requests, Duration period) {
        return RateLimiterConfig.custom().limitRefreshPeriod(period).limitForPeriod(requests).timeoutDuration(period).build();
    }

    @Generated
    private LanguageModel(int requestsPerPeriod, Duration period) {
        this.requestsPerPeriod = requestsPerPeriod;
        this.period = period;
    }

    static {
        rateLimiterRegistry = RateLimiterRegistry.of(Arrays.stream(LanguageModel.values()).collect(Collectors.toMap(Enum::name, lm -> LanguageModel.requestsPerPeriodConfig(lm.requestsPerPeriod, lm.period))));
    }
}

