/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.concourse;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ChangeResourceVersion
extends Recipe {
    @Option(displayName="Resource type", description="Update any resources of this type", example="git")
    private final String resourceType;
    @Option(displayName="Version", description="If less than this version, update. If not provided, clears pins.", example="2.0", required=false)
    @Nullable
    private final String version;

    public String getDisplayName() {
        return "Change resource version";
    }

    public String getDescription() {
        return "Pin or unpin a resource to a particular version.";
    }

    protected YamlVisitor<ExecutionContext> getVisitor() {
        final JsonPathMatcher resourceMatcher = new JsonPathMatcher("$.resources[?(@.type == '" + this.resourceType + "')]");
        final JsonPathMatcher versionMatcher = new JsonPathMatcher("$.resources[?(@.type == '" + this.resourceType + "')].version");
        return new YamlVisitor<ExecutionContext>(){

            public Yaml visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                if (resourceMatcher.encloses(this.getCursor()) && ChangeResourceVersion.this.version != null && mapping.getEntries().stream().noneMatch(e -> e.getKey().getValue().equals("version"))) {
                    Yaml.Mapping versionMapping = (Yaml.Mapping)((Yaml.Document)((Yaml.Documents)new YamlParser().parse(new String[]{"version: " + ChangeResourceVersion.this.version}).get(0)).getDocuments().get(0)).getBlock();
                    Yaml.Mapping.Entry versionEntry = (Yaml.Mapping.Entry)versionMapping.getEntries().get(0);
                    versionEntry = (Yaml.Mapping.Entry)this.autoFormat((Yaml)versionEntry, ctx, this.getCursor());
                    return mapping.withEntries(ListUtils.concat((List)mapping.getEntries(), (Object)versionEntry));
                }
                return super.visitMapping(mapping, (Object)ctx);
            }

            public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                if (versionMatcher.matches(this.getCursor())) {
                    if (ChangeResourceVersion.this.version == null) {
                        return null;
                    }
                    if (entry.getValue() instanceof Yaml.Scalar && !((Yaml.Scalar)entry.getValue()).getValue().equals(ChangeResourceVersion.this.version)) {
                        return entry.withValue((Yaml.Block)((Yaml.Scalar)entry.getValue()).withValue(ChangeResourceVersion.this.version));
                    }
                }
                return super.visitMappingEntry(entry, (Object)ctx);
            }
        };
    }

    public ChangeResourceVersion(String resourceType, String version) {
        this.resourceType = resourceType;
        this.version = version;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return "ChangeResourceVersion(resourceType=" + this.getResourceType() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeResourceVersion)) {
            return false;
        }
        ChangeResourceVersion other = (ChangeResourceVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangeResourceVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

