/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.concourse;

import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.tree.Yaml;

public class Parameters {
    private Parameters() {
    }

    public static boolean isParameter(Yaml yaml) {
        if (yaml instanceof Yaml.Scalar) {
            String scalar = ((Yaml.Scalar)yaml).getValue();
            return scalar.startsWith("((") && scalar.endsWith("))");
        }
        return false;
    }

    public static JsonPathMatcher toJsonPath(Yaml yaml) {
        if (!Parameters.isParameter(yaml)) {
            throw new IllegalArgumentException("Yaml element is not a Concourse parameter");
        }
        String scalar = ((Yaml.Scalar)yaml).getValue();
        return new JsonPathMatcher("$." + scalar.substring(2, scalar.length() - 2));
    }
}

