/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.concourse;

import java.beans.ConstructorProperties;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class FindResource
extends Recipe {
    @Option(displayName="Type", description="Resource type", example="git")
    private final String type;

    public String getDisplayName() {
        return "Find resource";
    }

    public String getDescription() {
        return "Find a Concourse resource by name.";
    }

    protected YamlVisitor<ExecutionContext> getVisitor() {
        final JsonPathMatcher resource = new JsonPathMatcher("$.resources[*].type");
        return new YamlVisitor<ExecutionContext>(){

            public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext executionContext) {
                if (resource.matches(this.getCursor()) && entry.getValue() instanceof Yaml.Scalar && ((Yaml.Scalar)entry.getValue()).getValue().equals(FindResource.this.type)) {
                    return entry.withMarkers(entry.getMarkers().searchResult());
                }
                return super.visitMappingEntry(entry, (Object)executionContext);
            }
        };
    }

    @ConstructorProperties(value={"type"})
    public FindResource(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String toString() {
        return "FindResource(type=" + this.getType() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindResource)) {
            return false;
        }
        FindResource other = (FindResource)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

