/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.concourse;

import java.beans.ConstructorProperties;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.concourse.Parameters;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ChangeValue
extends Recipe {
    @Option(displayName="Key path", description="The key to match and replace.", example="$.resources[?(@.type == 'git')].source.uri")
    private final String keyPath;
    @Option(displayName="Old value", description="Only change if the existing value matches.", required=false)
    @Nullable
    private final String oldValue;
    @Option(displayName="New value", description="New value to replace the old value with.")
    private final String newValue;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pipeline*.yml")
    @Nullable
    private final String fileMatcher;

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDisplayName() {
        return "Change Concourse value";
    }

    public String getDescription() {
        return "Change every value matching the key pattern.";
    }

    public Validated validate() {
        return super.validate().and(Validated.test((String)"oldValue", (String)"oldValue must be a compilable regular expression", (Object)this.oldValue, ps -> {
            if (this.oldValue != null) {
                try {
                    Pattern.compile(this.oldValue);
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            }
            return true;
        }));
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        final JsonPathMatcher keyPathMatcher = new JsonPathMatcher(this.keyPath);
        final Pattern oldValuePattern = this.oldValue == null ? null : Pattern.compile(this.oldValue);
        final ArrayList parametersToChange = new ArrayList();
        YamlVisitor<ExecutionContext> findParametersToChange = new YamlVisitor<ExecutionContext>(){

            public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                if (keyPathMatcher.matches(this.getCursor()) && entry.getValue() instanceof Yaml.Scalar && Parameters.isParameter((Yaml)entry.getValue())) {
                    parametersToChange.add(Parameters.toJsonPath((Yaml)entry.getValue()));
                }
                return super.visitMappingEntry(entry, (Object)ctx);
            }
        };
        for (SourceFile sourceFile2 : before) {
            findParametersToChange.visit((Tree)sourceFile2, (Object)ctx);
        }
        return ListUtils.map(before, sourceFile -> {
            boolean matchesFile;
            if (!(sourceFile instanceof Yaml.Documents)) {
                return sourceFile;
            }
            boolean bl = matchesFile = this.fileMatcher == null;
            if (!matchesFile) {
                Path sourcePath = sourceFile.getSourcePath();
                PathMatcher pathMatcher = sourcePath.getFileSystem().getPathMatcher("glob:" + this.fileMatcher);
                matchesFile = pathMatcher.matches(sourcePath);
            }
            if (matchesFile) {
                return (SourceFile)new YamlIsoVisitor<ExecutionContext>(){

                    public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                        Yaml.Mapping.Entry e = super.visitMappingEntry(entry, (Object)ctx);
                        for (JsonPathMatcher changeParam : parametersToChange) {
                            e = this.maybeReplaceValue(e, changeParam);
                        }
                        e = this.maybeReplaceValue(e, keyPathMatcher);
                        return e;
                    }

                    private Yaml.Mapping.Entry maybeReplaceValue(Yaml.Mapping.Entry e, JsonPathMatcher matcher) {
                        if (matcher.matches(this.getCursor()) && e.getValue() instanceof Yaml.Scalar) {
                            Yaml.Scalar scalar = (Yaml.Scalar)e.getValue();
                            if (Parameters.isParameter((Yaml)scalar)) {
                                if (!keyPathMatcher.matches(this.getCursor())) {
                                    String value = scalar.getValue();
                                    String asKeyPath = "$." + scalar.getValue().substring(2, value.length() - 2);
                                    ChangeValue.this.doNext(new ChangeValue(asKeyPath, null, ChangeValue.this.newValue, ChangeValue.this.fileMatcher));
                                }
                                return e;
                            }
                            if (oldValuePattern == null || oldValuePattern.matcher(scalar.getValue()).matches()) {
                                e = e.withValue((Yaml.Block)scalar.withValue(ChangeValue.this.newValue));
                            }
                        }
                        return e;
                    }
                }.visitNonNull((Tree)sourceFile, (Object)ctx);
            }
            return sourceFile;
        });
    }

    @ConstructorProperties(value={"keyPath", "oldValue", "newValue", "fileMatcher"})
    public ChangeValue(String keyPath, @Nullable String oldValue, String newValue, @Nullable String fileMatcher) {
        this.keyPath = keyPath;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.fileMatcher = fileMatcher;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    @Nullable
    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "ChangeValue(keyPath=" + this.getKeyPath() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeValue)) {
            return false;
        }
        ChangeValue other = (ChangeValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

