/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.concourse.search;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.search.FindKey;

public final class FindPinnedResource
extends Recipe {
    @Option(displayName="Resource type", description="The resource type to search for. Leave empty to find all pins.", example="git", required=false)
    @Nullable
    private final String resourceType;

    public String getDisplayName() {
        return "Find pinned resources by type";
    }

    public String getDescription() {
        return "Find resources of a particular type that have pinned versions.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public List<Recipe> getRecipeList() {
        String search = "$.resources[" + (this.resourceType == null ? "*" : "?(@.type == '" + this.resourceType + "')") + "].version";
        return Collections.singletonList(new FindKey(search));
    }

    @ConstructorProperties(value={"resourceType"})
    public FindPinnedResource(@Nullable String resourceType) {
        this.resourceType = resourceType;
    }

    @NonNull
    public String toString() {
        return "FindPinnedResource(resourceType=" + this.getResourceType() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindPinnedResource)) {
            return false;
        }
        FindPinnedResource other = (FindPinnedResource)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        return !(this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindPinnedResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        return result;
    }

    @Nullable
    public String getResourceType() {
        return this.resourceType;
    }
}

