/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.concourse;

import java.beans.ConstructorProperties;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.concourse.Parameters;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;
import org.openrewrite.yaml.tree.YamlKey;

public final class ChangeValue
extends ScanningRecipe<Accumulator> {
    @Option(displayName="Key path", description="The key to match and replace.", example="$.resources[?(@.type == 'git')].source.uri")
    private final String keyPath;
    @Option(displayName="Old value", description="Only change if the existing value matches.", required=false)
    @Nullable
    private final String oldValue;
    @Option(displayName="New value", description="New value to replace the old value with.")
    private final String newValue;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pipeline*.yml")
    @Nullable
    private final String fileMatcher;

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDisplayName() {
        return "Change Concourse value";
    }

    public String getDescription() {
        return "Change every value matching the key pattern.";
    }

    public Validated validate() {
        return super.validate().and(Validated.test((String)"oldValue", (String)"oldValue must be a compilable regular expression", (Object)this.oldValue, ps -> {
            if (this.oldValue != null) {
                try {
                    Pattern.compile(this.oldValue);
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            }
            return true;
        }));
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(new HashSet<JsonPathMatcher>(), new HashMap<JsonPathMatcher, JsonPathMatcher>());
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        final JsonPathMatcher keyPathMatcher = new JsonPathMatcher(this.keyPath);
        return new YamlVisitor<ExecutionContext>(){

            public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                if (Parameters.isParameter((Yaml)entry.getValue())) {
                    JsonPathMatcher pathKey = ChangeValue.getPath(this.getCursor());
                    JsonPathMatcher pathValue = Parameters.toJsonPath((Yaml)entry.getValue());
                    acc.getParametersMatchingTable().put(pathKey, pathValue);
                    if (acc.getParametersToChange().contains(pathKey)) {
                        acc.getParametersToChange().remove(pathKey);
                        acc.getParametersToChange().add(pathValue);
                    }
                }
                if (keyPathMatcher.matches(this.getCursor()) && entry.getValue() instanceof Yaml.Scalar && Parameters.isParameter((Yaml)entry.getValue())) {
                    JsonPathMatcher pathToChange = Parameters.toJsonPath((Yaml)entry.getValue());
                    if (acc.getParametersMatchingTable().containsKey(pathToChange)) {
                        pathToChange = acc.getParametersMatchingTable().get(pathToChange);
                    }
                    acc.getParametersToChange().add(pathToChange);
                }
                return super.visitMappingEntry(entry, (Object)ctx);
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        final JsonPathMatcher keyPathMatcher = new JsonPathMatcher(this.keyPath);
        final Pattern oldValuePattern = this.oldValue == null ? null : Pattern.compile(this.oldValue);
        return new YamlIsoVisitor<ExecutionContext>(){

            @Nullable
            public Yaml visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof Yaml.Documents) {
                    boolean matchesFile;
                    Yaml.Documents sourceFile = (Yaml.Documents)tree;
                    boolean bl = matchesFile = ChangeValue.this.fileMatcher == null;
                    if (!matchesFile) {
                        Path sourcePath = sourceFile.getSourcePath();
                        PathMatcher pathMatcher = sourcePath.getFileSystem().getPathMatcher("glob:" + ChangeValue.this.fileMatcher);
                        matchesFile = pathMatcher.matches(sourcePath);
                    }
                    if (!matchesFile) {
                        return sourceFile;
                    }
                    Yaml t = (Yaml)super.visit(tree, (Object)ctx);
                    String asKeyPath = (String)this.getCursor().pollMessage("asKeyPath");
                    while (asKeyPath != null) {
                        t = (Yaml)new org.openrewrite.yaml.ChangeValue(asKeyPath, ChangeValue.this.newValue).getVisitor().visitNonNull((Tree)t, (Object)ctx);
                        asKeyPath = (String)this.getCursor().pollMessage("asKeyPath");
                    }
                    return t;
                }
                return (Yaml)super.visit(tree, (Object)ctx);
            }

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Mapping.Entry e = super.visitMappingEntry(entry, (Object)ctx);
                JsonPathMatcher currentPath = ChangeValue.getPath(this.getCursor());
                if (acc.getParametersToChange().contains(currentPath)) {
                    e = this.maybeReplaceValue(e, currentPath);
                }
                e = this.maybeReplaceValue(e, keyPathMatcher);
                return e;
            }

            private Yaml.Mapping.Entry maybeReplaceValue(Yaml.Mapping.Entry entry, JsonPathMatcher matcher) {
                if (matcher.matches(this.getCursor()) && entry.getValue() instanceof Yaml.Scalar) {
                    Yaml.Scalar scalar = (Yaml.Scalar)entry.getValue();
                    if (Parameters.isParameter((Yaml)scalar)) {
                        if (!keyPathMatcher.matches(this.getCursor())) {
                            String value = scalar.getValue();
                            String asKeyPath = "$." + scalar.getValue().substring(2, value.length() - 2);
                            this.getCursor().getRoot().putMessage("asKeyPath", (Object)asKeyPath);
                        }
                        return entry;
                    }
                    if (oldValuePattern == null || oldValuePattern.matcher(scalar.getValue()).matches()) {
                        entry = entry.withValue((Yaml.Block)scalar.withValue(ChangeValue.this.newValue));
                    }
                }
                return entry;
            }
        };
    }

    private static JsonPathMatcher getPath(Cursor cursor) {
        List jsonPaths = cursor.getPathAsStream().filter(Yaml.Mapping.Entry.class::isInstance).map(Yaml.Mapping.Entry.class::cast).map(Yaml.Mapping.Entry::getKey).map(YamlKey::getValue).collect(Collectors.toList());
        Collections.reverse(jsonPaths);
        return new JsonPathMatcher("$." + String.join((CharSequence)".", jsonPaths));
    }

    @ConstructorProperties(value={"keyPath", "oldValue", "newValue", "fileMatcher"})
    public ChangeValue(String keyPath, @Nullable String oldValue, String newValue, @Nullable String fileMatcher) {
        this.keyPath = keyPath;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.fileMatcher = fileMatcher;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    @Nullable
    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "ChangeValue(keyPath=" + this.getKeyPath() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeValue)) {
            return false;
        }
        ChangeValue other = (ChangeValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }

    static final class Accumulator {
        private final Set<JsonPathMatcher> parametersToChange;
        private final Map<JsonPathMatcher, JsonPathMatcher> parametersMatchingTable;

        @ConstructorProperties(value={"parametersToChange", "parametersMatchingTable"})
        public Accumulator(Set<JsonPathMatcher> parametersToChange, Map<JsonPathMatcher, JsonPathMatcher> parametersMatchingTable) {
            this.parametersToChange = parametersToChange;
            this.parametersMatchingTable = parametersMatchingTable;
        }

        public Set<JsonPathMatcher> getParametersToChange() {
            return this.parametersToChange;
        }

        public Map<JsonPathMatcher, JsonPathMatcher> getParametersMatchingTable() {
            return this.parametersMatchingTable;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Set<JsonPathMatcher> this$parametersToChange = this.getParametersToChange();
            Set<JsonPathMatcher> other$parametersToChange = other.getParametersToChange();
            if (this$parametersToChange == null ? other$parametersToChange != null : !((Object)this$parametersToChange).equals(other$parametersToChange)) {
                return false;
            }
            Map<JsonPathMatcher, JsonPathMatcher> this$parametersMatchingTable = this.getParametersMatchingTable();
            Map<JsonPathMatcher, JsonPathMatcher> other$parametersMatchingTable = other.getParametersMatchingTable();
            return !(this$parametersMatchingTable == null ? other$parametersMatchingTable != null : !((Object)this$parametersMatchingTable).equals(other$parametersMatchingTable));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<JsonPathMatcher> $parametersToChange = this.getParametersToChange();
            result = result * 59 + ($parametersToChange == null ? 43 : ((Object)$parametersToChange).hashCode());
            Map<JsonPathMatcher, JsonPathMatcher> $parametersMatchingTable = this.getParametersMatchingTable();
            result = result * 59 + ($parametersMatchingTable == null ? 43 : ((Object)$parametersMatchingTable).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "ChangeValue.Accumulator(parametersToChange=" + this.getParametersToChange() + ", parametersMatchingTable=" + this.getParametersMatchingTable() + ")";
        }
    }
}

