/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.concourse;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.concourse.ChangeValue;
import org.openrewrite.internal.lang.NonNull;

@Incubating(since="0.1.0")
public final class UpdateGitResourceUri
extends Recipe {
    @Option(displayName="Optional old URI matcher", description="The old URI value to replace. This can be a regex pattern. If left empty, replace all occurrences.", required=false, example="https://github.com/openrewrite/rewrite")
    private final @Nullable String oldURIPattern;
    @Option(displayName="New URI", description="New URI value to replace the old URI value with.", example="git@gitlab.com:openrewrite/rewrite.git")
    private final String newURI;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pipeline*.yml")
    private final @Nullable String fileMatcher;

    public String getDisplayName() {
        return "Update git resource `source.uri` references";
    }

    public String getDescription() {
        return "Update git resource `source.uri` URI values to point to a new URI value.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new ChangeValue("$.resources[?(@.type == 'git')].source.uri", this.oldURIPattern, this.newURI, this.fileMatcher));
    }

    @ConstructorProperties(value={"oldURIPattern", "newURI", "fileMatcher"})
    @Generated
    public UpdateGitResourceUri(@Nullable String oldURIPattern, String newURI, @Nullable String fileMatcher) {
        this.oldURIPattern = oldURIPattern;
        this.newURI = newURI;
        this.fileMatcher = fileMatcher;
    }

    @Generated
    public @Nullable String getOldURIPattern() {
        return this.oldURIPattern;
    }

    @Generated
    public String getNewURI() {
        return this.newURI;
    }

    @Generated
    public @Nullable String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpdateGitResourceUri(oldURIPattern=" + this.getOldURIPattern() + ", newURI=" + this.getNewURI() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateGitResourceUri)) {
            return false;
        }
        UpdateGitResourceUri other = (UpdateGitResourceUri)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldURIPattern = this.getOldURIPattern();
        String other$oldURIPattern = other.getOldURIPattern();
        if (this$oldURIPattern == null ? other$oldURIPattern != null : !this$oldURIPattern.equals(other$oldURIPattern)) {
            return false;
        }
        String this$newURI = this.getNewURI();
        String other$newURI = other.getNewURI();
        if (this$newURI == null ? other$newURI != null : !this$newURI.equals(other$newURI)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpdateGitResourceUri;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldURIPattern = this.getOldURIPattern();
        result = result * 59 + ($oldURIPattern == null ? 43 : $oldURIPattern.hashCode());
        String $newURI = this.getNewURI();
        result = result * 59 + ($newURI == null ? 43 : $newURI.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

