/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cucumber.jvm;

import java.util.stream.Collectors;
import org.openrewrite.java.tree.J;

final class StepDefinitionArguments {
    private final String annotationName;
    private final J.Literal cucumberExpression;
    private final J.Lambda lambda;

    String template() {
        return "@#{}(#{any()})\npublic void #{}(#{}) throws Exception {\n\t#{any()};\n}";
    }

    private String formatMethodName() {
        return ((String)this.cucumberExpression.getValue()).replaceAll("\\s+", "_").replaceAll("[^A-Za-z0-9_]", "").toLowerCase();
    }

    private String formatMethodArguments() {
        return this.lambda.getParameters().getParameters().stream().filter(j -> j instanceof J.VariableDeclarations).map(j -> (J.VariableDeclarations)j).map(J.VariableDeclarations::toString).collect(Collectors.joining(", "));
    }

    Object[] parameters() {
        return new Object[]{this.annotationName, this.cucumberExpression, this.formatMethodName(), this.formatMethodArguments(), this.lambda.getBody()};
    }

    public StepDefinitionArguments(String annotationName, J.Literal cucumberExpression, J.Lambda lambda) {
        this.annotationName = annotationName;
        this.cucumberExpression = cucumberExpression;
        this.lambda = lambda;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public J.Literal getCucumberExpression() {
        return this.cucumberExpression;
    }

    public J.Lambda getLambda() {
        return this.lambda;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StepDefinitionArguments)) {
            return false;
        }
        StepDefinitionArguments other = (StepDefinitionArguments)o;
        String this$annotationName = this.getAnnotationName();
        String other$annotationName = other.getAnnotationName();
        if (this$annotationName == null ? other$annotationName != null : !this$annotationName.equals(other$annotationName)) {
            return false;
        }
        J.Literal this$cucumberExpression = this.getCucumberExpression();
        J.Literal other$cucumberExpression = other.getCucumberExpression();
        if (this$cucumberExpression == null ? other$cucumberExpression != null : !this$cucumberExpression.equals(other$cucumberExpression)) {
            return false;
        }
        J.Lambda this$lambda = this.getLambda();
        J.Lambda other$lambda = other.getLambda();
        return !(this$lambda == null ? other$lambda != null : !this$lambda.equals(other$lambda));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $annotationName = this.getAnnotationName();
        result = result * 59 + ($annotationName == null ? 43 : $annotationName.hashCode());
        J.Literal $cucumberExpression = this.getCucumberExpression();
        result = result * 59 + ($cucumberExpression == null ? 43 : $cucumberExpression.hashCode());
        J.Lambda $lambda = this.getLambda();
        result = result * 59 + ($lambda == null ? 43 : $lambda.hashCode());
        return result;
    }

    public String toString() {
        return "StepDefinitionArguments(annotationName=" + this.getAnnotationName() + ", cucumberExpression=" + this.getCucumberExpression() + ", lambda=" + this.getLambda() + ")";
    }
}

