/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cucumber.jvm;

import java.time.Duration;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.cucumber.jvm.CucumberJava8ClassVisitor;
import org.openrewrite.cucumber.jvm.HookArguments;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public final class CucumberJava8HookDefinitionToCucumberJava
extends Recipe {
    private static final String IO_CUCUMBER_JAVA8 = "io.cucumber.java8";
    private static final String IO_CUCUMBER_JAVA8_HOOK_BODY = "io.cucumber.java8.HookBody";
    private static final String IO_CUCUMBER_JAVA8_HOOK_NO_ARGS_BODY = "io.cucumber.java8.HookNoArgsBody";
    private static final String HOOK_BODY_DEFINITION = "io.cucumber.java8.LambdaGlue *(.., io.cucumber.java8.HookBody)";
    private static final String HOOK_NO_ARGS_BODY_DEFINITION = "io.cucumber.java8.LambdaGlue *(.., io.cucumber.java8.HookNoArgsBody)";
    private static final MethodMatcher HOOK_BODY_DEFINITION_METHOD_MATCHER = new MethodMatcher("io.cucumber.java8.LambdaGlue *(.., io.cucumber.java8.HookBody)");
    private static final MethodMatcher HOOK_NO_ARGS_BODY_DEFINITION_METHOD_MATCHER = new MethodMatcher("io.cucumber.java8.LambdaGlue *(.., io.cucumber.java8.HookNoArgsBody)");

    public String getDisplayName() {
        return "Replace Cucumber-Java8 hook definition with Cucumber-Java";
    }

    public String getDescription() {
        return "Replace LambdaGlue hook definitions with new annotated methods with the same body.";
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(HOOK_BODY_DEFINITION, true), new UsesMethod(HOOK_NO_ARGS_BODY_DEFINITION, true)}), (TreeVisitor)new CucumberJava8HooksVisitor());
    }

    public String toString() {
        return "CucumberJava8HookDefinitionToCucumberJava()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CucumberJava8HookDefinitionToCucumberJava)) {
            return false;
        }
        CucumberJava8HookDefinitionToCucumberJava other = (CucumberJava8HookDefinitionToCucumberJava)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof CucumberJava8HookDefinitionToCucumberJava;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    static final class CucumberJava8HooksVisitor
    extends JavaVisitor<ExecutionContext> {
        CucumberJava8HooksVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation mi, ExecutionContext p) {
            J.MethodInvocation methodInvocation = (J.MethodInvocation)super.visitMethodInvocation(mi, (Object)p);
            if (!HOOK_BODY_DEFINITION_METHOD_MATCHER.matches((MethodCall)methodInvocation) && !HOOK_NO_ARGS_BODY_DEFINITION_METHOD_MATCHER.matches((MethodCall)methodInvocation)) {
                return methodInvocation;
            }
            if (methodInvocation.getArguments().stream().anyMatch(arg -> !(arg instanceof J.Literal) && !(arg instanceof J.Lambda))) {
                return (J)SearchResult.found((Tree)methodInvocation, (String)"TODO Migrate manually");
            }
            HookArguments hookArguments = this.parseHookArguments(methodInvocation.getSimpleName(), methodInvocation.getArguments());
            J.ClassDeclaration parentClass = (J.ClassDeclaration)this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).getValue();
            this.doAfterVisit((TreeVisitor)new CucumberJava8ClassVisitor(parentClass.getType(), hookArguments.replacementImport(), hookArguments.template(), hookArguments.parameters()));
            return null;
        }

        HookArguments parseHookArguments(String methodName, List<Expression> arguments) {
            int argumentsSize = arguments.size();
            Expression lambdaArgument = arguments.get(argumentsSize - 1);
            HookArguments hookArguments = new HookArguments(methodName, null, null, (J.Lambda)lambdaArgument);
            if (argumentsSize == 1) {
                return hookArguments;
            }
            J.Literal firstArgument = (J.Literal)arguments.get(0);
            if (argumentsSize == 2) {
                if (firstArgument.getType() == JavaType.Primitive.String) {
                    return hookArguments.withTagExpression((String)firstArgument.getValue());
                }
                return hookArguments.withOrder((Integer)firstArgument.getValue());
            }
            return hookArguments.withTagExpression((String)firstArgument.getValue()).withOrder((Integer)((J.Literal)arguments.get(1)).getValue());
        }
    }
}

