/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cucumber.jvm;

import java.text.RuleBasedCollator;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class CucumberAnnotationToSuite
extends Recipe {
    private static final String IO_CUCUMBER_JUNIT_PLATFORM_ENGINE_CUCUMBER = "io.cucumber.junit.platform.engine.Cucumber";
    private static final String SUITE = "org.junit.platform.suite.api.Suite";
    private static final String SELECT_CLASSPATH_RESOURCE = "org.junit.platform.suite.api.SelectClasspathResource";

    public String getDisplayName() {
        return "Replace `@Cucumber` with `@Suite`";
    }

    public String getDescription() {
        return "Replace `@Cucumber` with `@Suite` and `@SelectClasspathResource(\"cucumber/annotated/class/package\")`.";
    }

    public @Nullable Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(IO_CUCUMBER_JUNIT_PLATFORM_ENGINE_CUCUMBER, null), (TreeVisitor)new ExecutionContextJavaIsoVisitor());
    }

    class ExecutionContextJavaIsoVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final AnnotationMatcher cucumberAnnoMatcher = new AnnotationMatcher("@io.cucumber.junit.platform.engine.Cucumber");

        ExecutionContextJavaIsoVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, ExecutionContext ctx) {
            J.ClassDeclaration classDecl = super.visitClassDeclaration(cd, (Object)ctx);
            if (classDecl.getAllAnnotations().stream().noneMatch(arg_0 -> ((AnnotationMatcher)this.cucumberAnnoMatcher).matches(arg_0))) {
                return classDecl;
            }
            JavaParser.Builder javaParserSupplier = JavaParser.fromJavaVersion().classpath(new String[]{"junit-platform-suite-api"});
            JavaType.FullyQualified classFqn = TypeUtils.asFullyQualified((JavaType)classDecl.getType());
            if (classFqn != null) {
                JavaCoordinates coordinates = classDecl.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName, new RuleBasedCollator("< SelectClasspathResource")));
                classDecl = (J.ClassDeclaration)JavaTemplate.builder((String)"@Suite @SelectClasspathResource(\"#{}\")").contextSensitive().javaParser(javaParserSupplier).imports(new String[]{CucumberAnnotationToSuite.SUITE, CucumberAnnotationToSuite.SELECT_CLASSPATH_RESOURCE}).build().apply(this.getCursor(), coordinates, new Object[]{classFqn.getPackageName().replace('.', '/')});
                this.maybeAddImport(CucumberAnnotationToSuite.SUITE);
                this.maybeAddImport(CucumberAnnotationToSuite.SELECT_CLASSPATH_RESOURCE);
                classDecl = classDecl.withLeadingAnnotations(ListUtils.map((List)classDecl.getLeadingAnnotations(), ann -> this.cucumberAnnoMatcher.matches(ann) ? null : ann));
                this.maybeRemoveImport(CucumberAnnotationToSuite.IO_CUCUMBER_JUNIT_PLATFORM_ENGINE_CUCUMBER);
            }
            return classDecl;
        }
    }
}

