/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.docker.trait;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.text.PlainText;
import org.openrewrite.trait.Reference;

public final class DockerfileImageReference
implements Reference {
    private final Cursor cursor;
    private final String value;

    public Reference.Kind getKind() {
        return Reference.Kind.IMAGE;
    }

    @Generated
    public DockerfileImageReference(Cursor cursor, String value) {
        this.cursor = cursor;
        this.value = value;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerfileImageReference)) {
            return false;
        }
        DockerfileImageReference other = (DockerfileImageReference)o;
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DockerfileImageReference(cursor=" + this.getCursor() + ", value=" + this.getValue() + ")";
    }

    public static class Provider
    implements Reference.Provider {
        public boolean isAcceptable(SourceFile sourceFile) {
            if (sourceFile instanceof PlainText) {
                PlainText text = (PlainText)sourceFile;
                String fileName = text.getSourcePath().toFile().getName();
                return !(!fileName.endsWith("Dockerfile") && !fileName.equals("Containerfile") || !text.getText().contains("FROM") && !text.getText().contains("from"));
            }
            return false;
        }

        public Set<Reference> getReferences(SourceFile sourceFile) {
            Cursor c = new Cursor(new Cursor(null, (Object)"root"), (Object)sourceFile);
            String[] words = ((PlainText)sourceFile).getText().replaceAll("\\s*#.*?\\n", "").replaceAll("\".*?\"", "").split("\\s+");
            HashSet<Reference> references = new HashSet<Reference>();
            ArrayList<String> imageVariables = new ArrayList<String>();
            int wordsLength = words.length;
            for (int i = 0; i < wordsLength; ++i) {
                String image;
                if ("from".equalsIgnoreCase(words[i])) {
                    image = words[i + 1].startsWith("--platform") ? words[i + 2] : words[i + 1];
                    references.add(new DockerfileImageReference(c, image));
                    continue;
                }
                if ("as".equalsIgnoreCase(words[i])) {
                    imageVariables.add(words[i + 1]);
                    continue;
                }
                if (!words[i].startsWith("--from") || words[i].split("=").length != 2 || imageVariables.contains(image = words[i].split("=")[1]) || StringUtils.isNumeric((String)image)) continue;
                references.add(new DockerfileImageReference(c, image));
            }
            return references;
        }
    }
}

