/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.docker.search;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFileWithReferences;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.docker.DockerImageVersion;
import org.openrewrite.docker.table.DockerBaseImages;
import org.openrewrite.docker.trait.ImageMatcher;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.text.Find;
import org.openrewrite.text.PlainText;
import org.openrewrite.trait.Reference;

public class FindDockerImageUses
extends Recipe {
    transient DockerBaseImages dockerBaseImages = new DockerBaseImages(this);

    public String getDisplayName() {
        return "Find uses of docker base images";
    }

    public String getDescription() {
        return "Produce an impact analysis of base images used in Dockerfiles, .gitlab-ci files, Kubernetes Deployment file, etc.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFileWithReferences) {
                    SourceFileWithReferences sourceFile = (SourceFileWithReferences)tree;
                    Path sourcePath = sourceFile.getSourcePath();
                    Collection references = sourceFile.getReferences().findMatches((Reference.Matcher)new ImageMatcher());
                    HashMap<Tree, List<Reference>> matches = new HashMap<Tree, List<Reference>>();
                    for (Reference ref : references) {
                        DockerImageVersion from = DockerImageVersion.of(ref.getValue());
                        FindDockerImageUses.this.dockerBaseImages.insertRow(ctx, new DockerBaseImages.Row(sourcePath.toString(), from.getImageName(), from.getVersion()));
                        matches.computeIfAbsent(ref.getTree(), t -> new ArrayList()).add(ref);
                    }
                    return new ReferenceFindSearchResultVisitor(matches).visit(tree, ctx, this.getCursor());
                }
                return tree;
            }
        };
    }

    private static final class ReferenceFindSearchResultVisitor
    extends TreeVisitor<Tree, ExecutionContext> {
        private final Map<Tree, List<Reference>> matches;

        public @Nullable Tree postVisit(Tree tree, ExecutionContext ctx) {
            List<Reference> references = this.matches.get(tree);
            if (references != null) {
                if (tree instanceof PlainText) {
                    String find = references.stream().map(Reference::getValue).sorted().collect(Collectors.joining("|"));
                    return new Find(find, Boolean.valueOf(true), null, null, null, null, Boolean.valueOf(true), null).getVisitor().visitNonNull(tree, (Object)ctx);
                }
                return SearchResult.found((Tree)tree, (String)references.get(0).getValue());
            }
            return tree;
        }

        @Generated
        public ReferenceFindSearchResultVisitor(Map<Tree, List<Reference>> matches) {
            this.matches = matches;
        }

        @Generated
        public Map<Tree, List<Reference>> getMatches() {
            return this.matches;
        }

        @Generated
        public String toString() {
            return "FindDockerImageUses.ReferenceFindSearchResultVisitor(matches=" + this.getMatches() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReferenceFindSearchResultVisitor)) {
                return false;
            }
            ReferenceFindSearchResultVisitor other = (ReferenceFindSearchResultVisitor)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            Map<Tree, List<Reference>> this$matches = this.getMatches();
            Map<Tree, List<Reference>> other$matches = other.getMatches();
            return !(this$matches == null ? other$matches != null : !((Object)this$matches).equals(other$matches));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReferenceFindSearchResultVisitor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Tree, List<Reference>> $matches = this.getMatches();
            result = result * 59 + ($matches == null ? 43 : ((Object)$matches).hashCode());
            return result;
        }
    }
}

