/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.dotnet;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.RecipeException;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.quark.Quark;
import org.openrewrite.scheduling.WorkingDirectoryExecutionContextView;
import org.openrewrite.text.PlainText;
import org.openrewrite.tree.ParseError;

abstract class UpgradeAssistantRecipe
extends ScanningRecipe<Accumulator> {
    private static final String FIRST_RECIPE = UpgradeAssistantRecipe.class.getName() + ".FIRST_RECIPE";
    private static final String PREVIOUS_RECIPE = UpgradeAssistantRecipe.class.getName() + ".PREVIOUS_RECIPE";
    private static final String INIT_REPO_DIR = UpgradeAssistantRecipe.class.getName() + ".INIT_REPO_DIR";
    private static final String UPGRADE_ASSISTANT = "upgrade-assistant";
    protected static final String DOTNET_HOME = System.getProperty("user.home") + File.separator + ".dotnet";

    UpgradeAssistantRecipe() {
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        Path directory = UpgradeAssistantRecipe.createDirectory(ctx);
        if (ctx.getMessage(INIT_REPO_DIR) == null) {
            ctx.putMessage(INIT_REPO_DIR, (Object)directory);
            ctx.putMessage(FIRST_RECIPE, (Object)ctx.getCycleDetails().getRecipePosition());
        }
        return new Accumulator(directory);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile && !(tree instanceof Quark) && !(tree instanceof ParseError)) {
                    SourceFile sourceFile = (SourceFile)tree;
                    if (Objects.equals(ctx.getMessage(FIRST_RECIPE), ctx.getCycleDetails().getRecipePosition())) {
                        acc.writeSource(sourceFile);
                    }
                }
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        Path previous = (Path)ctx.getMessage(PREVIOUS_RECIPE);
        if (previous != null && !Objects.equals(ctx.getMessage(FIRST_RECIPE), ctx.getCycleDetails().getRecipePosition())) {
            acc.copyFromPrevious(previous);
        }
        if (ctx.getCycle() == 1) {
            this.runUpgradeAssistant(acc, ctx);
        }
        ctx.putMessage(PREVIOUS_RECIPE, (Object)acc.getDirectory());
        return Collections.emptyList();
    }

    public abstract void runUpgradeAssistant(Accumulator var1, ExecutionContext var2);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execUpgradeAssistant(Path inputFile, Accumulator acc, ExecutionContext ctx) {
        List<String> command = this.buildUpgradeAssistantCommand(acc, ctx, inputFile);
        Path out = null;
        Path err = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(command);
            builder.directory(acc.getDirectory().toFile());
            Map<String, String> env = this.buildUpgradeAssistantEnv();
            env.forEach(builder.environment()::put);
            out = Files.createTempFile(WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx).getWorkingDirectory(), UPGRADE_ASSISTANT, null, new FileAttribute[0]);
            err = Files.createTempFile(WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx).getWorkingDirectory(), UPGRADE_ASSISTANT, null, new FileAttribute[0]);
            builder.redirectOutput(ProcessBuilder.Redirect.to(out.toFile()));
            builder.redirectError(ProcessBuilder.Redirect.to(err.toFile()));
            Process process = builder.start();
            process.waitFor(20L, TimeUnit.MINUTES);
            if (process.exitValue() != 0) {
                String error = "Command failed: " + String.join((CharSequence)" ", command);
                if (!Files.exists(err, new LinkOption[0])) throw new RuntimeException(error);
                error = error + "\n" + new String(Files.readAllBytes(err));
                throw new RuntimeException(error);
            }
            Iterator iterator = acc.beforeModificationTimestamps.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.processOutput(inputFile, out, acc);
                    this.deleteFile(out);
                    this.deleteFile(err);
                    return;
                }
                Map.Entry entry = iterator.next();
                Path path = (Path)entry.getKey();
                if (Files.exists(path, new LinkOption[0]) && Files.getLastModifiedTime(path, new LinkOption[0]).toMillis() <= (Long)entry.getValue()) continue;
                acc.addModifiedFile(path);
            }
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                this.deleteFile(out);
                this.deleteFile(err);
                throw throwable;
            }
        }
    }

    private Map<String, String> buildUpgradeAssistantEnv() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("TERM", "dumb");
        String path = System.getenv("PATH");
        env.put("PATH", path + File.pathSeparator + DOTNET_HOME);
        return env;
    }

    protected void deleteFile(@Nullable Path path) {
        if (path != null) {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public abstract List<String> buildUpgradeAssistantCommand(Accumulator var1, ExecutionContext var2, Path var3);

    protected Path getUpgradeAssistantPath() {
        Path cmdPath;
        String cmdName = UPGRADE_ASSISTANT;
        if (System.getProperty("os.name").contains("Windows")) {
            cmdName = cmdName + ".exe";
        }
        if (Files.exists(cmdPath = Paths.get(DOTNET_HOME, new String[0]).resolve("tools").resolve(cmdName), new LinkOption[0])) {
            return cmdPath;
        }
        for (String path : System.getenv("PATH").split(File.pathSeparator)) {
            cmdPath = Paths.get(path, new String[0]).resolve(cmdName);
            if (!Files.exists(cmdPath, new LinkOption[0])) continue;
            return cmdPath;
        }
        throw new IllegalStateException("Unable to find " + cmdName + " on PATH");
    }

    abstract void processOutput(Path var1, Path var2, Accumulator var3);

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    return UpgradeAssistantRecipe.this.createAfter(sourceFile, acc, ctx);
                }
                return tree;
            }
        };
    }

    protected SourceFile createAfter(SourceFile before, Accumulator acc, ExecutionContext ctx) {
        String error = acc.getFileError(acc.resolvedPath(before));
        if (error != null) {
            throw new RecipeException(error);
        }
        if (!acc.wasModified(before)) {
            return before;
        }
        return new PlainText(before.getId(), before.getSourcePath(), before.getMarkers(), (String)Optional.ofNullable(before.getCharset()).map(Charset::name).orElse(null), before.isCharsetBomMarked(), before.getFileAttributes(), null, acc.content(before), Collections.emptyList());
    }

    private static Path createDirectory(ExecutionContext ctx) {
        WorkingDirectoryExecutionContextView view = WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx);
        return Optional.of(view.getWorkingDirectory()).map(d -> d.resolve("repo")).map(d -> {
            try {
                return Files.createDirectory(d, new FileAttribute[0]).toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).orElseThrow(() -> new IllegalStateException("Failed to create working directory for repo"));
    }

    public static class Accumulator {
        private final Path directory;
        private final Map<Path, List<JsonNode>> fileResults = new HashMap<Path, List<JsonNode>>();
        private final Map<Path, String> fileErrors = new HashMap<Path, String>();
        private final Map<Path, Long> beforeModificationTimestamps = new HashMap<Path, Long>();
        private final Set<Path> modified = new LinkedHashSet<Path>();
        private final List<Path> projectFiles = new ArrayList<Path>();
        private final List<Path> solutionFiles = new ArrayList<Path>();
        private final Map<String, JsonNode> rules = new HashMap<String, JsonNode>();

        private void copyFromPrevious(final Path previous) {
            try {
                Files.walkFileTree(previous, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path target = directory.resolve(previous.relativize(dir));
                        if (!target.equals(directory)) {
                            Files.createDirectory(target, new FileAttribute[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try {
                            Path target = directory.resolve(previous.relativize(file));
                            Files.copy(file, target, new CopyOption[0]);
                            beforeModificationTimestamps.put(target, Files.getLastModifiedTime(target, new LinkOption[0]).toMillis());
                        }
                        catch (NoSuchFileException noSuchFileException) {
                            // empty catch block
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void writeSource(SourceFile sourceFile) {
            try {
                Path path = this.resolvedPath(sourceFile);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                PrintOutputCapture.MarkerPrinter markerPrinter = new PrintOutputCapture.MarkerPrinter(){};
                Path written = Files.write(path, sourceFile.printAll(new PrintOutputCapture((Object)0, markerPrinter)).getBytes(Optional.ofNullable(sourceFile.getCharset()).orElse(StandardCharsets.UTF_8)), new OpenOption[0]);
                this.beforeModificationTimestamps.put(written, Files.getLastModifiedTime(written, new LinkOption[0]).toMillis());
                String pathString = written.toString();
                if (this.isProjectFile(pathString)) {
                    this.projectFiles.add(written);
                } else if (this.isSolutionFile(pathString)) {
                    this.solutionFiles.add(written);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private boolean isProjectFile(String pathString) {
            return pathString.endsWith(".csproj") || pathString.endsWith(".vbproj") || pathString.endsWith(".fsproj");
        }

        private boolean isSolutionFile(String pathString) {
            return pathString.endsWith(".sln");
        }

        private void addModifiedFile(Path path) {
            this.modified.add(path);
        }

        private boolean wasModified(SourceFile tree) {
            return this.modified.contains(this.resolvedPath(tree));
        }

        public String content(SourceFile tree) {
            try {
                Path path = this.resolvedPath(tree);
                return tree.getCharset() != null ? new String(Files.readAllBytes(path), tree.getCharset()) : new String(Files.readAllBytes(path));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public Path resolvedPath(SourceFile tree) {
            return this.directory.resolve(tree.getSourcePath());
        }

        public void addFileResult(Path path, JsonNode jsonNode) {
            this.fileResults.computeIfAbsent(path, key -> new ArrayList()).add(jsonNode);
        }

        public @Nullable List<JsonNode> getFileResults(Path path) {
            return this.fileResults.get(path);
        }

        public void addFileError(Path path, String error) {
            this.fileErrors.put(path, error);
        }

        public @Nullable String getFileError(Path path) {
            return this.fileErrors.get(path);
        }

        public void addRule(String ruleId, JsonNode jsonNode) {
            this.rules.put(ruleId, jsonNode);
        }

        public String getRuleLabel(String ruleId) {
            return this.rules.get(ruleId).get("label").asText();
        }

        @Generated
        public String toString() {
            return "UpgradeAssistantRecipe.Accumulator(directory=" + this.getDirectory() + ", fileResults=" + this.fileResults + ", fileErrors=" + this.fileErrors + ", beforeModificationTimestamps=" + this.getBeforeModificationTimestamps() + ", modified=" + this.modified + ", projectFiles=" + this.getProjectFiles() + ", solutionFiles=" + this.getSolutionFiles() + ", rules=" + this.rules + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Path this$directory = this.getDirectory();
            Path other$directory = other.getDirectory();
            if (this$directory == null ? other$directory != null : !((Object)this$directory).equals(other$directory)) {
                return false;
            }
            Map<Path, List<JsonNode>> this$fileResults = this.fileResults;
            Map<Path, List<JsonNode>> other$fileResults = other.fileResults;
            if (this$fileResults == null ? other$fileResults != null : !((Object)this$fileResults).equals(other$fileResults)) {
                return false;
            }
            Map<Path, String> this$fileErrors = this.fileErrors;
            Map<Path, String> other$fileErrors = other.fileErrors;
            if (this$fileErrors == null ? other$fileErrors != null : !((Object)this$fileErrors).equals(other$fileErrors)) {
                return false;
            }
            Map<Path, Long> this$beforeModificationTimestamps = this.getBeforeModificationTimestamps();
            Map<Path, Long> other$beforeModificationTimestamps = other.getBeforeModificationTimestamps();
            if (this$beforeModificationTimestamps == null ? other$beforeModificationTimestamps != null : !((Object)this$beforeModificationTimestamps).equals(other$beforeModificationTimestamps)) {
                return false;
            }
            Set<Path> this$modified = this.modified;
            Set<Path> other$modified = other.modified;
            if (this$modified == null ? other$modified != null : !((Object)this$modified).equals(other$modified)) {
                return false;
            }
            List<Path> this$projectFiles = this.getProjectFiles();
            List<Path> other$projectFiles = other.getProjectFiles();
            if (this$projectFiles == null ? other$projectFiles != null : !((Object)this$projectFiles).equals(other$projectFiles)) {
                return false;
            }
            List<Path> this$solutionFiles = this.getSolutionFiles();
            List<Path> other$solutionFiles = other.getSolutionFiles();
            if (this$solutionFiles == null ? other$solutionFiles != null : !((Object)this$solutionFiles).equals(other$solutionFiles)) {
                return false;
            }
            Map<String, JsonNode> this$rules = this.rules;
            Map<String, JsonNode> other$rules = other.rules;
            return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Accumulator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Path $directory = this.getDirectory();
            result = result * 59 + ($directory == null ? 43 : ((Object)$directory).hashCode());
            Map<Path, List<JsonNode>> $fileResults = this.fileResults;
            result = result * 59 + ($fileResults == null ? 43 : ((Object)$fileResults).hashCode());
            Map<Path, String> $fileErrors = this.fileErrors;
            result = result * 59 + ($fileErrors == null ? 43 : ((Object)$fileErrors).hashCode());
            Map<Path, Long> $beforeModificationTimestamps = this.getBeforeModificationTimestamps();
            result = result * 59 + ($beforeModificationTimestamps == null ? 43 : ((Object)$beforeModificationTimestamps).hashCode());
            Set<Path> $modified = this.modified;
            result = result * 59 + ($modified == null ? 43 : ((Object)$modified).hashCode());
            List<Path> $projectFiles = this.getProjectFiles();
            result = result * 59 + ($projectFiles == null ? 43 : ((Object)$projectFiles).hashCode());
            List<Path> $solutionFiles = this.getSolutionFiles();
            result = result * 59 + ($solutionFiles == null ? 43 : ((Object)$solutionFiles).hashCode());
            Map<String, JsonNode> $rules = this.rules;
            result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
            return result;
        }

        @Generated
        public Accumulator(Path directory) {
            this.directory = directory;
        }

        @Generated
        public Path getDirectory() {
            return this.directory;
        }

        @Generated
        public Map<Path, Long> getBeforeModificationTimestamps() {
            return this.beforeModificationTimestamps;
        }

        @Generated
        public List<Path> getProjectFiles() {
            return this.projectFiles;
        }

        @Generated
        public List<Path> getSolutionFiles() {
            return this.solutionFiles;
        }
    }
}

