/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.dotnet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.dotnet.UpgradeAssistantRecipe;

public final class UpgradeAssistant
extends UpgradeAssistantRecipe {
    @Option(displayName="Target framework version", description="Target framework to which source project should be upgraded.", example="net9.0")
    private final String targetFramework;

    public String getDisplayName() {
        return "Upgrade a .NET project using upgrade-assistant";
    }

    public String getDescription() {
        return "Run [upgrade-assistant upgrade](https://learn.microsoft.com/en-us/dotnet/core/porting/upgrade-assistant-overview) across a repository to upgrade projects to a newer version of .NET.";
    }

    @Override
    public List<String> buildUpgradeAssistantCommand(UpgradeAssistantRecipe.Accumulator acc, ExecutionContext ctx, Path projectFile) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getUpgradeAssistantPath().toString());
        command.add("upgrade");
        command.add(projectFile.toString());
        command.add("--non-interactive");
        command.add("--operation");
        command.add("Inplace");
        command.add("--targetFramework");
        command.add(this.targetFramework);
        return command;
    }

    @Override
    public void runUpgradeAssistant(UpgradeAssistantRecipe.Accumulator acc, ExecutionContext ctx) {
        for (Path projectFile : acc.getProjectFiles()) {
            this.execUpgradeAssistant(projectFile, acc, ctx);
        }
    }

    @Override
    protected void processOutput(Path projectFile, Path output, UpgradeAssistantRecipe.Accumulator acc) {
        Path projectDir = projectFile.getParent();
        try (BufferedReader reader = Files.newBufferedReader(output);){
            String fileName = null;
            ArrayList<String> transformerLogs = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("Unknown target framework")) {
                    acc.addFileError(projectFile, line);
                    break;
                }
                String[] parts = line.split("\\s+");
                if (parts.length != 0) {
                    String token = parts[0];
                    if (token.startsWith("file.")) {
                        fileName = parts[1].replace("...", "");
                    } else if (fileName != null) {
                        if ("Succeeded".equals(token) || "Skipped".equals(token) || "Failed".equals(token)) {
                            if ("Failed".equals(token)) {
                                String error = transformerLogs.stream().map(String::trim).collect(Collectors.joining("\n"));
                                acc.addFileError(projectDir.resolve(fileName), error);
                            }
                            fileName = null;
                            transformerLogs.clear();
                        } else {
                            transformerLogs.add(line);
                        }
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Generated
    public UpgradeAssistant(String targetFramework) {
        this.targetFramework = targetFramework;
    }

    @Generated
    public String getTargetFramework() {
        return this.targetFramework;
    }

    @Generated
    public String toString() {
        return "UpgradeAssistant(targetFramework=" + this.getTargetFramework() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeAssistant)) {
            return false;
        }
        UpgradeAssistant other = (UpgradeAssistant)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$targetFramework = this.getTargetFramework();
        String other$targetFramework = other.getTargetFramework();
        return !(this$targetFramework == null ? other$targetFramework != null : !this$targetFramework.equals(other$targetFramework));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpgradeAssistant;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $targetFramework = this.getTargetFramework();
        result = result * 59 + ($targetFramework == null ? 43 : $targetFramework.hashCode());
        return result;
    }
}

