/*
 * Copyright 2024 the original author or authors.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.openrewrite.dotnet;

import lombok.Value;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

import java.net.URL;

public class UpgradeAssistantAnalysis extends DataTable<UpgradeAssistantAnalysis.Row> {
    public UpgradeAssistantAnalysis(Recipe recipe) {
        super(recipe,
                "Upgrade-assistant analysis",
                ".NET project upgrade analysis report generated by upgrade-assistant.");
    }

    @Value
    public static class Row {
        @Column(displayName = "Project path",
                description = "The path of the analyzed project file.")
        String projectPath;

        @Column(displayName = "Source path",
                description = "The path of the analyzed source file.")
        String sourcePath;

        @Column(displayName = "Issue",
                description = "Issue.")
        String issue;

        @Column(displayName = "Description",
                description = "Description of issue.")
        String description;

        @Column(displayName = "Code snippet",
                description = "Code snippet raising issue.")
        String codeSnippet;

        @Column(displayName = "Recommendation",
                description = "Recommendation to address issue.")
        @Nullable
        String recommendation;

        @Column(displayName = "Link",
                description = "Link to further documentation related to updating the source file.")
        @Nullable
        URL link;
    }
}
