/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.featureflags.search;

import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.InvocationMatcher;
import org.openrewrite.analysis.constantfold.ConstantFold;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.dataflow.DataFlowSpec;
import org.openrewrite.analysis.dataflow.Dataflow;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public final class FindFeatureFlag
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern to match against. The first argument must be the feature key as `String`.", example="dev.openfeature.sdk.Client getBooleanValue(String, Boolean)")
    private final String methodPattern;
    @Option(displayName="Feature key", description="The unique key for the feature flag.", example="flag-key-123abc", required=false)
    @Nullable
    private final String featureKey;

    public String getDisplayName() {
        return "Find a feature flag";
    }

    public String getDescription() {
        return "Find a feature flag matching method pattern.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = new MethodMatcher(this.methodPattern, true);
        return Preconditions.check((TreeVisitor)new UsesMethod(methodMatcher), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (!methodMatcher.matches((MethodCall)m)) {
                    return m;
                }
                if (StringUtils.isBlank((String)FindFeatureFlag.this.featureKey)) {
                    return (J.MethodInvocation)SearchResult.found((Tree)m);
                }
                Boolean matchesFeatureKey = (Boolean)this.getCursor().getMessage("feature.found");
                if (matchesFeatureKey != null && matchesFeatureKey.booleanValue()) {
                    return (J.MethodInvocation)SearchResult.found((Tree)m);
                }
                return m;
            }

            public Expression visitExpression(Expression expression, ExecutionContext ctx) {
                Expression e = super.visitExpression(expression, (Object)ctx);
                if (this.findFeatureKeyFlow() && methodMatcher.matches((MethodCall)this.getCursor().firstEnclosing(J.MethodInvocation.class))) {
                    this.getCursor().putMessageOnFirstEnclosing(J.MethodInvocation.class, "feature.found", (Object)true);
                }
                return e;
            }

            private boolean findFeatureKeyFlow() {
                if (StringUtils.isBlank((String)FindFeatureFlag.this.featureKey)) {
                    return false;
                }
                final InvocationMatcher matcher = InvocationMatcher.fromMethodMatcher((MethodMatcher)methodMatcher);
                return Dataflow.startingAt((Cursor)this.getCursor()).findSinks(new DataFlowSpec(){

                    public boolean isSource(DataFlowNode srcNode) {
                        return (Boolean)ConstantFold.findConstantLiteralValue((DataFlowNode)srcNode, String.class).map(FindFeatureFlag.this.featureKey::equals).orSome((Object)false);
                    }

                    public boolean isSink(DataFlowNode sinkNode) {
                        return matcher.advanced().isFirstParameter(sinkNode.getCursor());
                    }
                }).isSome();
            }
        });
    }

    @Generated
    public FindFeatureFlag(String methodPattern, String featureKey) {
        this.methodPattern = methodPattern;
        this.featureKey = featureKey;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public String getFeatureKey() {
        return this.featureKey;
    }

    @Generated
    public String toString() {
        return "FindFeatureFlag(methodPattern=" + this.getMethodPattern() + ", featureKey=" + this.getFeatureKey() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindFeatureFlag)) {
            return false;
        }
        FindFeatureFlag other = (FindFeatureFlag)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$featureKey = this.getFeatureKey();
        String other$featureKey = other.getFeatureKey();
        return !(this$featureKey == null ? other$featureKey != null : !this$featureKey.equals(other$featureKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindFeatureFlag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $featureKey = this.getFeatureKey();
        result = result * 59 + ($featureKey == null ? 43 : $featureKey.hashCode());
        return result;
    }
}

