/*
 * Copyright 2024 the original author or authors.
 * <p>
 * Licensed under the Moderne Source Available License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * https://docs.moderne.io/licensing/moderne-source-available-license
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.openrewrite.featureflags.openfeature.search;

import lombok.EqualsAndHashCode;
import lombok.Value;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Option;
import org.openrewrite.Recipe;

import java.util.Collections;
import java.util.List;

@EqualsAndHashCode(callSuper = false)
@Value
public class FindFeatureFlag extends Recipe {

    @Option(displayName = "Feature key",
            description = "The unique key for the feature flag.",
            example = "flag-key-123abc",
            required = false)
    @Nullable
    String featureKey;

    @Override
    public String getDisplayName() {
        return "Find an OpenFeature feature flag";
    }

    @Override
    public String getDescription() {
        return "Find an OpenFeature feature flag.";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new org.openrewrite.featureflags.search.FindFeatureFlag(
                "dev.openfeature.sdk.Features get*Value(String, ..)", featureKey));
    }
}
