/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.featureflags.launchdarkly;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.featureflags.RemoveStringFlag;

public final class RemoveStringVariation
extends Recipe {
    @Option(displayName="Feature flag key", description="The key of the feature flag to remove.", example="flag-key-123abc")
    private final String featureKey;
    @Option(displayName="Replacement value", description="The value to replace the feature flag check with.", example="topic-456")
    private final String replacementValue;

    public String getDisplayName() {
        return "Remove LaunchDarkly's `boolVariation` for feature key";
    }

    public String getDescription() {
        return "Replace `boolVariation` invocations for feature key with value, and simplify constant if branch execution.";
    }

    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new RemoveStringFlag("com.launchdarkly.sdk.server.LDClient stringVariation(String, com.launchdarkly.sdk.*, String)", this.featureKey, this.replacementValue));
    }

    @Generated
    public RemoveStringVariation(String featureKey, String replacementValue) {
        this.featureKey = featureKey;
        this.replacementValue = replacementValue;
    }

    @Generated
    public String getFeatureKey() {
        return this.featureKey;
    }

    @Generated
    public String getReplacementValue() {
        return this.replacementValue;
    }

    @Generated
    public String toString() {
        return "RemoveStringVariation(featureKey=" + this.getFeatureKey() + ", replacementValue=" + this.getReplacementValue() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveStringVariation)) {
            return false;
        }
        RemoveStringVariation other = (RemoveStringVariation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$featureKey = this.getFeatureKey();
        String other$featureKey = other.getFeatureKey();
        if (this$featureKey == null ? other$featureKey != null : !this$featureKey.equals(other$featureKey)) {
            return false;
        }
        String this$replacementValue = this.getReplacementValue();
        String other$replacementValue = other.getReplacementValue();
        return !(this$replacementValue == null ? other$replacementValue != null : !this$replacementValue.equals(other$replacementValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveStringVariation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $featureKey = this.getFeatureKey();
        result = result * 59 + ($featureKey == null ? 43 : $featureKey.hashCode());
        String $replacementValue = this.getReplacementValue();
        result = result * 59 + ($replacementValue == null ? 43 : $replacementValue.hashCode());
        return result;
    }
}

