/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.featureflags;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Repeat;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.constantfold.ConstantFold;
import org.openrewrite.analysis.util.CursorUtil;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.RemoveUnusedLocalVariables;
import org.openrewrite.staticanalysis.RemoveUnusedPrivateFields;
import org.openrewrite.staticanalysis.SimplifyConstantIfBranchExecution;

public final class RemoveStringFlag
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern to match against. The first argument must be the feature key as `String`.", example="dev.openfeature.sdk.Client getBooleanValue(String, Boolean)")
    private final String methodPattern;
    @Option(displayName="Feature flag key", description="The key of the feature flag to remove.", example="flag-key-123abc")
    private final String featureKey;
    @Option(displayName="Replacement value", description="The value to replace the feature flag check with.", example="topic-456")
    private final String replacementValue;

    public String getDisplayName() {
        return "Remove a String feature flag for feature key";
    }

    public String getDescription() {
        return "Replace method invocations for feature key with value, and simplify constant if branch execution.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = new MethodMatcher(this.methodPattern, true);
        JavaVisitor<ExecutionContext> visitor = new JavaVisitor<ExecutionContext>(){

            public @Nullable J visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (multiVariable.getVariables().size() == 1 && this.matches(((J.VariableDeclarations.NamedVariable)multiVariable.getVariables().get(0)).getInitializer())) {
                    final J.Identifier identifierToReplaceWithLiteral = ((J.VariableDeclarations.NamedVariable)multiVariable.getVariables().get(0)).getName();
                    this.doAfterVisit((TreeVisitor)new JavaVisitor<ExecutionContext>(){

                        public J visitIdentifier(J.Identifier ident, ExecutionContext ctx) {
                            if (SemanticallyEqual.areEqual((J)ident, (J)identifierToReplaceWithLiteral)) {
                                return this.buildLiteral().withPrefix(ident.getPrefix());
                            }
                            return ident;
                        }
                    });
                    this.cleanUpAfterReplacements();
                    return null;
                }
                return super.visitVariableDeclarations(multiVariable, (Object)ctx);
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (this.matches((Expression)mi)) {
                    this.cleanUpAfterReplacements();
                    return this.buildLiteral().withPrefix(mi.getPrefix());
                }
                return mi;
            }

            private boolean matches(@Nullable Expression expression) {
                if (methodMatcher.matches(expression)) {
                    Expression firstArgument = (Expression)((J.MethodInvocation)expression).getArguments().get(0);
                    return (Boolean)CursorUtil.findCursorForTree((Cursor)this.getCursor(), (Tree)firstArgument).bind(c -> ConstantFold.findConstantLiteralValue((Cursor)c, String.class)).map(RemoveStringFlag.this.featureKey::equals).orSome((Object)false);
                }
                return false;
            }

            private void cleanUpAfterReplacements() {
                this.doAfterVisit(new SimplifyConstantIfBranchExecution().getVisitor());
                this.doAfterVisit(Repeat.repeatUntilStable((TreeVisitor)new RemoveUnusedLocalVariables(null, Boolean.valueOf(true)).getVisitor(), (int)3));
                this.doAfterVisit(new RemoveUnusedPrivateFields().getVisitor());
            }

            private J.Literal buildLiteral() {
                return new J.Literal(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, (Object)RemoveStringFlag.this.replacementValue, '\"' + RemoveStringFlag.this.replacementValue + '\"', null, JavaType.Primitive.String);
            }
        };
        return Preconditions.check((TreeVisitor)new UsesMethod(methodMatcher), (TreeVisitor)visitor);
    }

    @Generated
    public RemoveStringFlag(String methodPattern, String featureKey, String replacementValue) {
        this.methodPattern = methodPattern;
        this.featureKey = featureKey;
        this.replacementValue = replacementValue;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public String getFeatureKey() {
        return this.featureKey;
    }

    @Generated
    public String getReplacementValue() {
        return this.replacementValue;
    }

    @Generated
    public String toString() {
        return "RemoveStringFlag(methodPattern=" + this.getMethodPattern() + ", featureKey=" + this.getFeatureKey() + ", replacementValue=" + this.getReplacementValue() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveStringFlag)) {
            return false;
        }
        RemoveStringFlag other = (RemoveStringFlag)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$featureKey = this.getFeatureKey();
        String other$featureKey = other.getFeatureKey();
        if (this$featureKey == null ? other$featureKey != null : !this$featureKey.equals(other$featureKey)) {
            return false;
        }
        String this$replacementValue = this.getReplacementValue();
        String other$replacementValue = other.getReplacementValue();
        return !(this$replacementValue == null ? other$replacementValue != null : !this$replacementValue.equals(other$replacementValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveStringFlag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $featureKey = this.getFeatureKey();
        result = result * 59 + ($featureKey == null ? 43 : $featureKey.hashCode());
        String $replacementValue = this.getReplacementValue();
        result = result * 59 + ($replacementValue == null ? 43 : $replacementValue.hashCode());
        return result;
    }
}

