/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gitlab.core;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.DeleteKey;

public final class RemoveTemplate
extends Recipe {
    @Option(displayName="Template", description="The name of the template to match.", example="Terraform/Base.gitlab-ci.yml")
    private final String oldTemplate;

    public String getDisplayName() {
        return "Remove GitLab template";
    }

    public String getDescription() {
        return "Remove a GitLab template from use.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new DeleteKey("$.include[?(@.template =~ '" + this.oldTemplate + "(?:@.+)?')]", ".gitlab-ci.yml").getVisitor();
    }

    @Generated
    public RemoveTemplate(String oldTemplate) {
        this.oldTemplate = oldTemplate;
    }

    @Generated
    public String getOldTemplate() {
        return this.oldTemplate;
    }

    @Generated
    public String toString() {
        return "RemoveTemplate(oldTemplate=" + this.getOldTemplate() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveTemplate)) {
            return false;
        }
        RemoveTemplate other = (RemoveTemplate)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldTemplate = this.getOldTemplate();
        String other$oldTemplate = other.getOldTemplate();
        return !(this$oldTemplate == null ? other$oldTemplate != null : !this$oldTemplate.equals(other$oldTemplate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldTemplate = this.getOldTemplate();
        result = result * 59 + ($oldTemplate == null ? 43 : $oldTemplate.hashCode());
        return result;
    }
}

