/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gitlab;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.yaml.MergeYaml;

public final class AddComponent
extends Recipe {
    @Option(displayName="Component", description="Name of the component to use add.", example="$CI_SERVER_FQDN/components/opentofu/full-pipeline")
    private final String newComponent;
    @Option(displayName="Version", description="Version of the component to add.", example="0.10.0")
    private final String version;
    @Option(displayName="Inputs", description="The set of inputs to provide", example="opentofu_version: 1.6.1", required=false)
    private final @Nullable List<String> inputs;
    @Option(displayName="Insert mode", description="Choose an insertion point when multiple mappings exist. Default is `Last`.", valid={"Before", "After", "Last"}, required=false)
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MergeYaml.InsertMode insertMode;

    public String getDisplayName() {
        return "Add GitLab component";
    }

    public String getDescription() {
        return "Add a GitLab component to an existing list, or add a new list where none was present.";
    }

    public List<Recipe> getRecipeList() {
        StringBuilder includeBlock = new StringBuilder().append("include:\n").append(" - component: ").append(this.newComponent).append("@").append(this.version).append("\n");
        if (this.inputs != null && !this.inputs.isEmpty()) {
            includeBlock.append("   inputs:\n");
            this.inputs.forEach(input -> includeBlock.append("     ").append((String)input).append("\n"));
        }
        return Collections.singletonList(new MergeYaml("$", includeBlock.toString(), Boolean.valueOf(false), "component", ".gitlab-ci.yml", this.insertMode, null, null));
    }

    @Generated
    public AddComponent(String newComponent, String version, @Nullable List<String> inputs, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MergeYaml.InsertMode insertMode) {
        this.newComponent = newComponent;
        this.version = version;
        this.inputs = inputs;
        this.insertMode = insertMode;
    }

    @Generated
    public String getNewComponent() {
        return this.newComponent;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable List<String> getInputs() {
        return this.inputs;
    }

    @Generated
    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MergeYaml.InsertMode getInsertMode() {
        return this.insertMode;
    }

    @Generated
    public String toString() {
        return "AddComponent(newComponent=" + this.getNewComponent() + ", version=" + this.getVersion() + ", inputs=" + this.getInputs() + ", insertMode=" + this.getInsertMode() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddComponent)) {
            return false;
        }
        AddComponent other = (AddComponent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$newComponent = this.getNewComponent();
        String other$newComponent = other.getNewComponent();
        if (this$newComponent == null ? other$newComponent != null : !this$newComponent.equals(other$newComponent)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List<String> this$inputs = this.getInputs();
        List<String> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        MergeYaml.InsertMode this$insertMode = this.getInsertMode();
        MergeYaml.InsertMode other$insertMode = other.getInsertMode();
        return !(this$insertMode == null ? other$insertMode != null : !this$insertMode.equals(other$insertMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $newComponent = this.getNewComponent();
        result = result * 59 + ($newComponent == null ? 43 : $newComponent.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List<String> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        MergeYaml.InsertMode $insertMode = this.getInsertMode();
        result = result * 59 + ($insertMode == null ? 43 : $insertMode.hashCode());
        return result;
    }
}

