/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gitlab;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.yaml.MergeYaml;

public final class AddTemplate
extends Recipe {
    @Option(displayName="Template", description="Name of the template to use instead.", example="OpenTofu/Base.gitlab-ci.yml")
    private final String newTemplate;
    @Option(displayName="Insert mode", description="Choose an insertion point when multiple mappings exist. Default is `Last`.", valid={"Before", "After", "Last"}, required=false)
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MergeYaml.InsertMode insertMode;

    public String getDisplayName() {
        return "Add GitLab template";
    }

    public String getDescription() {
        return "Add a GitLab template to an existing list, or add a new list where none was present.";
    }

    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new MergeYaml("$", "include:\n - template: " + this.newTemplate, Boolean.valueOf(false), "template", ".gitlab-ci.yml", this.insertMode, null, null));
    }

    @Generated
    public AddTemplate(String newTemplate, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MergeYaml.InsertMode insertMode) {
        this.newTemplate = newTemplate;
        this.insertMode = insertMode;
    }

    @Generated
    public String getNewTemplate() {
        return this.newTemplate;
    }

    @Generated
    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MergeYaml.InsertMode getInsertMode() {
        return this.insertMode;
    }

    @Generated
    public String toString() {
        return "AddTemplate(newTemplate=" + this.getNewTemplate() + ", insertMode=" + this.getInsertMode() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddTemplate)) {
            return false;
        }
        AddTemplate other = (AddTemplate)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$newTemplate = this.getNewTemplate();
        String other$newTemplate = other.getNewTemplate();
        if (this$newTemplate == null ? other$newTemplate != null : !this$newTemplate.equals(other$newTemplate)) {
            return false;
        }
        MergeYaml.InsertMode this$insertMode = this.getInsertMode();
        MergeYaml.InsertMode other$insertMode = other.getInsertMode();
        return !(this$insertMode == null ? other$insertMode != null : !this$insertMode.equals(other$insertMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $newTemplate = this.getNewTemplate();
        result = result * 59 + ($newTemplate == null ? 43 : $newTemplate.hashCode());
        MergeYaml.InsertMode $insertMode = this.getInsertMode();
        result = result * 59 + ($insertMode == null ? 43 : $insertMode.hashCode());
        return result;
    }
}

