/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gitlab;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.yaml.MergeYaml;

public final class AddStages
extends Recipe {
    @Option(displayName="Stages", description="Stages to add.", example="build,test,deploy")
    private final List<String> stages;
    @Option(displayName="Accept theirs", description="When the set of stages would conflict, prefer the original value.", required=false)
    private final @Nullable Boolean acceptTheirs;
    @Option(displayName="Insert mode", description="Choose an insertion point when multiple mappings exist. Default is `Last`.", valid={"Before", "After", "Last"}, required=false)
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MergeYaml.InsertMode insertMode;

    public String getDisplayName() {
        return "Add GitLab stages";
    }

    public String getDescription() {
        return "Add or Update the set of stages defined in `.gitlab-ci.yml`.";
    }

    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new MergeYaml("$", "stages:\n  - " + String.join((CharSequence)"\n  - ", this.stages), this.acceptTheirs, "stages", ".gitlab-ci.yml", this.insertMode, null, null));
    }

    @Generated
    public AddStages(List<String> stages, @Nullable Boolean acceptTheirs, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MergeYaml.InsertMode insertMode) {
        this.stages = stages;
        this.acceptTheirs = acceptTheirs;
        this.insertMode = insertMode;
    }

    @Generated
    public List<String> getStages() {
        return this.stages;
    }

    @Generated
    public @Nullable Boolean getAcceptTheirs() {
        return this.acceptTheirs;
    }

    @Generated
    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MergeYaml.InsertMode getInsertMode() {
        return this.insertMode;
    }

    @Generated
    public String toString() {
        return "AddStages(stages=" + this.getStages() + ", acceptTheirs=" + this.getAcceptTheirs() + ", insertMode=" + this.getInsertMode() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddStages)) {
            return false;
        }
        AddStages other = (AddStages)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$acceptTheirs = this.getAcceptTheirs();
        Boolean other$acceptTheirs = other.getAcceptTheirs();
        if (this$acceptTheirs == null ? other$acceptTheirs != null : !((Object)this$acceptTheirs).equals(other$acceptTheirs)) {
            return false;
        }
        List<String> this$stages = this.getStages();
        List<String> other$stages = other.getStages();
        if (this$stages == null ? other$stages != null : !((Object)this$stages).equals(other$stages)) {
            return false;
        }
        MergeYaml.InsertMode this$insertMode = this.getInsertMode();
        MergeYaml.InsertMode other$insertMode = other.getInsertMode();
        return !(this$insertMode == null ? other$insertMode != null : !this$insertMode.equals(other$insertMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddStages;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $acceptTheirs = this.getAcceptTheirs();
        result = result * 59 + ($acceptTheirs == null ? 43 : ((Object)$acceptTheirs).hashCode());
        List<String> $stages = this.getStages();
        result = result * 59 + ($stages == null ? 43 : ((Object)$stages).hashCode());
        MergeYaml.InsertMode $insertMode = this.getInsertMode();
        result = result * 59 + ($insertMode == null ? 43 : $insertMode.hashCode());
        return result;
    }
}

