/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gitlab.search;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.yaml.search.FindKey;

public final class FindComponent
extends Recipe {
    @Option(displayName="Component", description="The component key to look for", example="$CI_SERVER_FQDN/components/opentofu/full-pipeline")
    private final String component;

    public String getDisplayName() {
        return "Find GitLab Component";
    }

    public String getDescription() {
        return "Find a GitLab Component in use.";
    }

    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new FindKey("$.include[?(@.component =~ '" + this.component + "(?:@.+)?')].component"));
    }

    @Generated
    public FindComponent(String component) {
        this.component = component;
    }

    @Generated
    public String getComponent() {
        return this.component;
    }

    @Generated
    public String toString() {
        return "FindComponent(component=" + this.getComponent() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindComponent)) {
            return false;
        }
        FindComponent other = (FindComponent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$component = this.getComponent();
        String other$component = other.getComponent();
        return !(this$component == null ? other$component != null : !this$component.equals(other$component));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        return result;
    }
}

