/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gitlab.search;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.yaml.search.FindKey;

public final class FindTemplate
extends Recipe {
    @Option(displayName="Template", description="The template key to look for", example="Terraform/Base.gitlab-ci.yml")
    private final String template;

    public String getDisplayName() {
        return "Find GitLab Template";
    }

    public String getDescription() {
        return "Find a GitLab Template in use.";
    }

    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new FindKey("$.include[?(@.template =~ '" + this.template + "(?:@.+)?')].template"));
    }

    @Generated
    public FindTemplate(String template) {
        this.template = template;
    }

    @Generated
    public String getTemplate() {
        return this.template;
    }

    @Generated
    public String toString() {
        return "FindTemplate(template=" + this.getTemplate() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindTemplate)) {
            return false;
        }
        FindTemplate other = (FindTemplate)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        return !(this$template == null ? other$template != null : !this$template.equals(other$template));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        return result;
    }
}

