/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gitlab;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.yaml.ChangeValue;

public final class ChangeComponent
extends Recipe {
    @Option(displayName="Old Component", description="The name of the component to match.", example="$CI_SERVER_FQDN/components/opentofu/full-pipeline")
    private final String oldComponent;
    @Option(displayName="Old Component version", description="Version of the existing component to use match.", example="0.10.0")
    private final String oldComponentVersion;
    @Option(displayName="New Component", description="Name of the new component to use instead.", example="$CI_SERVER_FQDN/components/opentofu/full-pipeline", required=false)
    private final @Nullable String newComponent;
    @Option(displayName="New Component version", description="Version of the new component to use instead.", example="0.10.0")
    private final String newComponentVersion;

    public String getDisplayName() {
        return "Change GitLab Component";
    }

    public String getDescription() {
        return "Change a GitLab Component in use.";
    }

    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new ChangeValue(String.format("$.include[?(@.component =~ '%s@%s')].component", this.oldComponent, this.oldComponentVersion), (this.newComponent == null ? this.oldComponent : this.newComponent) + "@" + this.newComponentVersion, ".gitlab-ci.yml"));
    }

    @Generated
    public ChangeComponent(String oldComponent, String oldComponentVersion, @Nullable String newComponent, String newComponentVersion) {
        this.oldComponent = oldComponent;
        this.oldComponentVersion = oldComponentVersion;
        this.newComponent = newComponent;
        this.newComponentVersion = newComponentVersion;
    }

    @Generated
    public String getOldComponent() {
        return this.oldComponent;
    }

    @Generated
    public String getOldComponentVersion() {
        return this.oldComponentVersion;
    }

    @Generated
    public @Nullable String getNewComponent() {
        return this.newComponent;
    }

    @Generated
    public String getNewComponentVersion() {
        return this.newComponentVersion;
    }

    @Generated
    public String toString() {
        return "ChangeComponent(oldComponent=" + this.getOldComponent() + ", oldComponentVersion=" + this.getOldComponentVersion() + ", newComponent=" + this.getNewComponent() + ", newComponentVersion=" + this.getNewComponentVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeComponent)) {
            return false;
        }
        ChangeComponent other = (ChangeComponent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldComponent = this.getOldComponent();
        String other$oldComponent = other.getOldComponent();
        if (this$oldComponent == null ? other$oldComponent != null : !this$oldComponent.equals(other$oldComponent)) {
            return false;
        }
        String this$oldComponentVersion = this.getOldComponentVersion();
        String other$oldComponentVersion = other.getOldComponentVersion();
        if (this$oldComponentVersion == null ? other$oldComponentVersion != null : !this$oldComponentVersion.equals(other$oldComponentVersion)) {
            return false;
        }
        String this$newComponent = this.getNewComponent();
        String other$newComponent = other.getNewComponent();
        if (this$newComponent == null ? other$newComponent != null : !this$newComponent.equals(other$newComponent)) {
            return false;
        }
        String this$newComponentVersion = this.getNewComponentVersion();
        String other$newComponentVersion = other.getNewComponentVersion();
        return !(this$newComponentVersion == null ? other$newComponentVersion != null : !this$newComponentVersion.equals(other$newComponentVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldComponent = this.getOldComponent();
        result = result * 59 + ($oldComponent == null ? 43 : $oldComponent.hashCode());
        String $oldComponentVersion = this.getOldComponentVersion();
        result = result * 59 + ($oldComponentVersion == null ? 43 : $oldComponentVersion.hashCode());
        String $newComponent = this.getNewComponent();
        result = result * 59 + ($newComponent == null ? 43 : $newComponent.hashCode());
        String $newComponentVersion = this.getNewComponentVersion();
        result = result * 59 + ($newComponentVersion == null ? 43 : $newComponentVersion.hashCode());
        return result;
    }
}

