/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gitlab;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.yaml.MergeYaml;

public final class AddTemplate
extends Recipe {
    @Option(displayName="Template", description="Name of the template to use instead.", example="OpenTofu/Base.gitlab-ci.yml")
    private final String newTemplate;

    public String getDisplayName() {
        return "Add GitLab template";
    }

    public String getDescription() {
        return "Add a GitLab template to an existing list, or add a new list where none was present.";
    }

    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new MergeYaml("$", "include:\n - template: " + this.newTemplate, Boolean.valueOf(false), "template", ".gitlab-ci.yml", null));
    }

    @Generated
    public AddTemplate(String newTemplate) {
        this.newTemplate = newTemplate;
    }

    @Generated
    public String getNewTemplate() {
        return this.newTemplate;
    }

    @Generated
    public String toString() {
        return "AddTemplate(newTemplate=" + this.getNewTemplate() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddTemplate)) {
            return false;
        }
        AddTemplate other = (AddTemplate)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$newTemplate = this.getNewTemplate();
        String other$newTemplate = other.getNewTemplate();
        return !(this$newTemplate == null ? other$newTemplate != null : !this$newTemplate.equals(other$newTemplate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $newTemplate = this.getNewTemplate();
        result = result * 59 + ($newTemplate == null ? 43 : $newTemplate.hashCode());
        return result;
    }
}

