/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Collections;
import java.util.List;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.properties.ChangePropertyValue;

public class UpdateGradleWrapperProperties
extends Recipe {
    @Option(displayName="Gradle version", description="Gradle releases are listed on [gradle.org](https://gradle.org/releases/).", example="7.1.1")
    private final String gradleVersion;

    public UpdateGradleWrapperProperties(String gradleVersion) {
        this.gradleVersion = gradleVersion;
    }

    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new ChangePropertyValue("distributionUrl", "https\\://services.gradle.org/distributions/gradle-" + this.gradleVersion + "-bin.zip", null, "gradle/wrapper/gradle-wrapper.properties"));
    }

    public String getDisplayName() {
        return "Update Gradle wrapper properties file";
    }

    public String getDescription() {
        return "This is generally enough to update the Gradle version, unless the launch scripts have changed as well.";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateGradleWrapperProperties)) {
            return false;
        }
        UpdateGradleWrapperProperties other = (UpdateGradleWrapperProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$gradleVersion = this.getGradleVersion();
        String other$gradleVersion = other.getGradleVersion();
        return !(this$gradleVersion == null ? other$gradleVersion != null : !this$gradleVersion.equals(other$gradleVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateGradleWrapperProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $gradleVersion = this.getGradleVersion();
        result = result * 59 + ($gradleVersion == null ? 43 : $gradleVersion.hashCode());
        return result;
    }

    public String getGradleVersion() {
        return this.gradleVersion;
    }
}

