/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.config.Environment;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.Java11ParserVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.style.NamedStyles;

@SupportedAnnotationTypes(value={"*"})
public class RewriteAnnotationProcessor
extends AbstractProcessor {
    private boolean rewriteDisabled = false;
    @Nullable
    private Trees trees;
    private Recipe recipe;
    private List<NamedStyles> styles;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        String activeRecipes = System.getProperty("rewrite.activeRecipes");
        processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Running Rewrite");
        if (System.getProperty("rewrite.disable") != null || activeRecipes == null) {
            this.rewriteDisabled = true;
            return;
        }
        this.trees = Trees.instance(processingEnv);
        Environment env = Environment.builder((Properties)System.getProperties()).scanRuntimeClasspath(new String[0]).scanUserHome().build();
        this.recipe = env.activateRecipes(activeRecipes.split(","));
        String activeStyles = System.getProperty("rewrite.activeStyles");
        this.styles = env.activateStyles(activeStyles == null ? new String[]{} : activeStyles.split(","));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.rewriteDisabled || roundEnv.processingOver()) {
            return false;
        }
        ArrayList<J.CompilationUnit> compilationUnits = new ArrayList<J.CompilationUnit>(roundEnv.getRootElements().size());
        HashMap sharedClassTypes = new HashMap();
        for (Element element : roundEnv.getRootElements()) {
            JCTree.JCCompilationUnit cu = this.toUnit(element);
            if (cu == null) continue;
            try {
                String source;
                Path sourcePath = Paths.get(cu.getSourceFile().toUri());
                String userDir = System.getProperty("user.dir");
                if (userDir != null) {
                    sourcePath = Paths.get(userDir, new String[0]).relativize(sourcePath).normalize();
                }
                try {
                    source = StringUtils.readFully((InputStream)cu.getSourceFile().openInputStream());
                }
                catch (Throwable ignored) {
                    source = cu.getSourceFile().getCharContent(true).toString();
                }
                Java11ParserVisitor parser = new Java11ParserVisitor(sourcePath, source, false, this.styles, sharedClassTypes, (ExecutionContext)new InMemoryExecutionContext(), new Context());
                compilationUnits.add((J.CompilationUnit)parser.scan((Tree)cu, (Object)Space.EMPTY));
            }
            catch (Throwable t) {
                StringWriter exceptionWriter = new StringWriter();
                t.printStackTrace();
                t.printStackTrace(new PrintWriter(exceptionWriter));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to map compilation unit to Rewrite AST at " + cu.getSourceFile().toUri() + ": " + exceptionWriter);
            }
        }
        List results = this.recipe.run(compilationUnits);
        if (!results.isEmpty()) {
            new File("./.rewrite").mkdirs();
            Path path = new File("./.rewrite").toPath().resolve("rewrite.patch");
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                for (Result result : results) {
                    String diff = result.diff();
                    try {
                        writer.write(diff + "\n");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                writer.flush();
            }
            catch (Exception e) {
                StringWriter exceptionWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(exceptionWriter));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to generate rewrite diff file: " + exceptionWriter.toString());
            }
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Nullable
    private JCTree.JCCompilationUnit toUnit(Element element) {
        TreePath path = null;
        if (this.trees != null) {
            try {
                path = this.trees.getPath(element);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (path == null) {
            return null;
        }
        return (JCTree.JCCompilationUnit)path.getCompilationUnit();
    }
}

