/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jenkins.BomLookup;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.AddManagedDependency;
import org.openrewrite.maven.ChangeManagedDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class AddPluginsBom
extends ScanningRecipe<Scanned> {
    private static final BomLookup LOOKUP = new BomLookup();
    private static final String PLUGINS_BOM_GROUP_ID = "io.jenkins.tools.bom";

    public String getDisplayName() {
        return "Add or correct Jenkins plugins BOM";
    }

    public String getDescription() {
        return "Adds [Jenkins plugins BOM](https://www.jenkins.io/doc/developer/plugin-development/dependency-management/#jenkins-plugin-bom) at the latest release if the project depends on any managed versions or an outdated BOM is present. BOMs are expected to be synchronized to Jenkins LTS versions, so this will also remove any mismatched BOMs (Such as using Jenkins 2.387.3, but importing bom-2.319.x). If the expected BOM is already added, the version will not be upgraded.";
    }

    public Scanned getInitialValue(ExecutionContext ctx) {
        return new Scanned();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Scanned acc) {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext executionContext) {
                Xml.Document d = super.visitDocument(document, (Object)executionContext);
                if (acc.needsPluginsBom()) {
                    return (Xml.Document)SearchResult.found((Tree)d);
                }
                return d;
            }

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                Xml.Tag t = super.visitTag(tag, (Object)executionContext);
                if (this.isPropertyTag()) {
                    if (Objects.equals("jenkins.version", t.getName())) {
                        acc.jenkinsVersion = t.getValue().orElse("");
                    }
                } else if (this.isManagedDependencyTag()) {
                    String groupId = tag.getChildValue("groupId").orElse("");
                    String artifactId = tag.getChildValue("artifactId").orElse("");
                    if (AddPluginsBom.PLUGINS_BOM_GROUP_ID.equals(groupId) && !artifactId.isEmpty()) {
                        acc.foundPluginsBoms.add(new Artifact(groupId, artifactId));
                    }
                } else {
                    ResolvedDependency dependency = this.findDependency(tag);
                    if (dependency != null && LOOKUP.inBom(dependency.getGroupId(), dependency.getArtifactId())) {
                        acc.foundPlugins.add(new Artifact(dependency.getGroupId(), dependency.getArtifactId()));
                    }
                }
                return t;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Scanned acc) {
        return Preconditions.check((boolean)acc.needsPluginsBom(), (TreeVisitor)new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext executionContext) {
                Xml maven = super.visitDocument(document, (Object)executionContext);
                Artifact bomToChange = acc.bomToChange();
                if (acc.foundPluginsBoms.isEmpty()) {
                    this.doAfterVisit(new AddManagedDependency(AddPluginsBom.PLUGINS_BOM_GROUP_ID, acc.bomName(), "latest.release", "import", "pom", null, null, Boolean.valueOf(true), null, null).getVisitor());
                } else if (bomToChange != null) {
                    this.doAfterVisit(new ChangeManagedDependencyGroupIdAndArtifactId(bomToChange.groupId, bomToChange.artifactId, bomToChange.groupId, acc.bomName(), "latest.release").getVisitor());
                }
                for (Artifact artifact : acc.foundPlugins) {
                    this.doAfterVisit(new RemoveRedundantDependencyVersions(artifact.getGroupId(), artifact.getArtifactId(), Boolean.valueOf(false), null).getVisitor());
                }
                return maven;
            }

            public Xml visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)executionContext);
                if (this.isManagedDependencyTag()) {
                    boolean isImport = "import".equals(t.getChildValue("scope").orElse(""));
                    boolean isPom = "pom".equals(t.getChildValue("type").orElse(""));
                    String groupId = t.getChildValue("groupId").orElse("");
                    String artifactId = t.getChildValue("artifactId").orElse("");
                    Artifact artifact = new Artifact(groupId, artifactId);
                    if (isPom && isImport && acc.bomsToRemove().contains(artifact)) {
                        this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)tag, true));
                    }
                }
                return t;
            }
        });
    }

    @NonNull
    public String toString() {
        return "AddPluginsBom()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPluginsBom)) {
            return false;
        }
        AddPluginsBom other = (AddPluginsBom)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddPluginsBom;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    static class Scanned {
        private static final Predicate<String> LTS_PATTERN = Pattern.compile("^\\d\\.\\d+\\.\\d$").asPredicate();
        final Set<Artifact> foundPlugins = new HashSet<Artifact>();
        final Set<Artifact> foundPluginsBoms = new LinkedHashSet<Artifact>();
        String jenkinsVersion = "";

        Scanned() {
        }

        boolean needsPluginsBom() {
            boolean hasPluginsThatBomIncludes = !this.foundPlugins.isEmpty();
            boolean hasJenkinsVersion = !this.jenkinsVersion.isEmpty();
            boolean hasOnlyExpectedPluginsBom = this.foundPluginsBoms.equals(this.expectedBoms());
            boolean hasWrongPluginsBom = !this.foundPluginsBoms.isEmpty() && !hasOnlyExpectedPluginsBom;
            return hasWrongPluginsBom || hasPluginsThatBomIncludes && hasJenkinsVersion && !hasOnlyExpectedPluginsBom;
        }

        String bomName() {
            boolean isLts = LTS_PATTERN.test(this.jenkinsVersion);
            if (!isLts) {
                return "bom-weekly";
            }
            int lastIndex = this.jenkinsVersion.lastIndexOf(".");
            String prefix = this.jenkinsVersion.substring(0, lastIndex);
            return "bom-" + prefix + ".x";
        }

        @Nullable
        Artifact bomToChange() {
            if (this.foundPluginsBoms.isEmpty() || this.expectedBoms().equals(this.foundPluginsBoms)) {
                return null;
            }
            Artifact expected = new Artifact(AddPluginsBom.PLUGINS_BOM_GROUP_ID, this.bomName());
            Artifact change = null;
            for (Artifact bom : this.foundPluginsBoms) {
                if (expected.equals(bom)) {
                    return null;
                }
                if (change != null) continue;
                change = bom;
            }
            return change;
        }

        Set<Artifact> bomsToRemove() {
            HashSet<Artifact> remove = new HashSet<Artifact>();
            Artifact change = this.bomToChange();
            for (Artifact bom : this.foundPluginsBoms) {
                boolean wanted = this.bomName().equals(bom.getArtifactId());
                boolean changing = Objects.equals(change, bom);
                if (wanted || changing) continue;
                remove.add(bom);
            }
            return remove;
        }

        Set<Artifact> expectedBoms() {
            HashSet<Artifact> expected = new HashSet<Artifact>();
            expected.add(new Artifact(AddPluginsBom.PLUGINS_BOM_GROUP_ID, this.bomName()));
            return expected;
        }
    }

    static final class Artifact {
        private final String groupId;
        private final String artifactId;

        @ConstructorProperties(value={"groupId", "artifactId"})
        public Artifact(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Artifact)) {
                return false;
            }
            Artifact other = (Artifact)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "AddPluginsBom.Artifact(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
        }
    }
}

