/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jhipster;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.format.AutoFormat;
import org.openrewrite.java.marker.JavaSearchResult;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;

public class FixCwe338
extends Recipe {
    private static final ThreadLocal<JavaParser> JAVA_PARSER = ThreadLocal.withInitial(() -> JavaParser.fromJavaVersion().dependsOn(Arrays.asList(Parser.Input.fromString((String)"package org.apache.commons.lang;\nimport java.util.Random;\npublic class RandomStringUtils {\n  public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {}\n}\n"), Parser.Input.fromString((String)"package org.apache.commons.lang3;\nimport java.util.Random;\npublic class RandomStringUtils {\n  public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {}\n}\n"))).build());
    private static final String COMMONS_LANG_2 = "COMMONS_LANG_2";

    public String getDisplayName() {
        return "Fix CWE-338 with `SecureRandom`";
    }

    public String getDescription() {
        return "Use a cryptographically strong pseudo-random number generator (PRNG).";
    }

    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                if (cu.getPackageDeclaration() == null) {
                    return cu;
                }
                return super.visitCompilationUnit(cu, (Object)executionContext);
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, ExecutionContext executionContext) {
                if (cd.getSimpleName().equals("RandomUtil")) {
                    return cd.withMarkers(cd.getMarkers().addIfAbsent((Marker)new JavaSearchResult((Recipe)FixCwe338.this)));
                }
                return cd;
            }
        };
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                boolean fieldExists = classDecl.getBody().getStatements().stream().filter(it -> it instanceof J.VariableDeclarations).map(J.VariableDeclarations.class::cast).filter(it -> it.getVariables().size() == 1).map(it -> (J.VariableDeclarations.NamedVariable)it.getVariables().get(0)).anyMatch(it -> it.getSimpleName().equals("SECURE_RANDOM"));
                if (fieldExists) {
                    return classDecl;
                }
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)executionContext);
                cd = cd.withBody(cd.getBody().withStatements(cd.getBody().getStatements().stream().filter(it -> !(it instanceof J.VariableDeclarations)).collect(Collectors.toList())));
                cd = cd.withBody((J.Block)cd.getBody().withTemplate(this.template("private static String generateRandomAlphanumericString() {\n    return RandomStringUtils.random(DEF_COUNT, 0, 0, true, true, null, SECURE_RANDOM);\n}\nprivate static final SecureRandom SECURE_RANDOM = new SecureRandom();\nprivate static final int DEF_COUNT = 20;\n\nstatic {\n    SECURE_RANDOM.nextBytes(new byte[64]);\n}\n").javaParser(JAVA_PARSER::get).imports(new String[]{"java.security.SecureRandom"}).build(), cd.getBody().getCoordinates().lastStatement(), new Object[0]));
                this.maybeAddImport("java.security.SecureRandom");
                List existingStatements = cd.getBody().getStatements();
                List reorderedStatements = Stream.concat(existingStatements.subList(existingStatements.size() - 3, existingStatements.size()).stream(), existingStatements.subList(0, existingStatements.size() - 3).stream()).collect(Collectors.toList());
                cd = cd.withBody(cd.getBody().withStatements(reorderedStatements));
                String randomStringUtilsFqn = this.getCursor().pollMessage(FixCwe338.COMMONS_LANG_2) == null ? "org.apache.commons.lang3.RandomStringUtils" : "org.apache.commons.lang.RandomStringUtils";
                this.maybeAddImport(randomStringUtilsFqn);
                this.doAfterVisit((Recipe)new AutoFormat());
                return cd;
            }

            public J.Import visitImport(J.Import _import, ExecutionContext executionContext) {
                if (_import.getPackageName().equals("org.apache.commons.lang")) {
                    this.getCursor().putMessage(FixCwe338.COMMONS_LANG_2, (Object)true);
                }
                return _import;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, ExecutionContext executionContext) {
                return (J.MethodInvocation)m.withTemplate(this.template("generateRandomAlphanumericString()").javaParser(JAVA_PARSER::get).build(), m.getCoordinates().replace(), new Object[0]);
            }
        };
    }
}

