/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jhipster;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.format.AutoFormatVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;

public class FixCwe338
extends Recipe {
    private static final JavaParser.Builder<?, ?> JAVA_PARSER = JavaParser.fromJavaVersion().dependsOn(Arrays.asList(Parser.Input.fromString((String)"package org.apache.commons.lang;\nimport java.util.Random;\npublic class RandomStringUtils {\n  public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {}\n}\n"), Parser.Input.fromString((String)"package org.apache.commons.lang3;\nimport java.util.Random;\npublic class RandomStringUtils {\n  public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {}\n}\n")));
    private static final String COMMONS_LANG_2 = "COMMONS_LANG_2";

    public String getDisplayName() {
        return "Fix CWE-338 with `SecureRandom`";
    }

    public String getDescription() {
        return "Use a cryptographically strong pseudo-random number generator (PRNG).";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                if (cu.getPackageDeclaration() == null) {
                    return cu;
                }
                return super.visitCompilationUnit(cu, (Object)ctx);
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, ExecutionContext ctx) {
                if ("RandomUtil".equals(cd.getSimpleName())) {
                    return (J.ClassDeclaration)SearchResult.found((Tree)cd);
                }
                return cd;
            }
        }, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                boolean fieldExists = classDecl.getBody().getStatements().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).filter(it -> it.getVariables().size() == 1).map(it -> (J.VariableDeclarations.NamedVariable)it.getVariables().get(0)).anyMatch(it -> "SECURE_RANDOM".equals(it.getSimpleName()));
                if (fieldExists) {
                    return classDecl;
                }
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                cd = cd.withBody(cd.getBody().withStatements(cd.getBody().getStatements().stream().filter(it -> !(it instanceof J.VariableDeclarations)).collect(Collectors.toList())));
                cd = cd.withBody((J.Block)JavaTemplate.builder((String)"private static String generateRandomAlphanumericString() {\n    return RandomStringUtils.random(DEF_COUNT, 0, 0, true, true, null, SECURE_RANDOM);\n}\nprivate static final SecureRandom SECURE_RANDOM = new SecureRandom();\nprivate static final int DEF_COUNT = 20;\n\nstatic {\n    SECURE_RANDOM.nextBytes(new byte[64]);\n}\n").contextSensitive().javaParser(JAVA_PARSER).imports(new String[]{"java.security.SecureRandom"}).build().apply(new Cursor(new Cursor(this.getCursor().getParent(), (Object)cd), (Object)cd.getBody()), cd.getBody().getCoordinates().lastStatement(), new Object[0]));
                this.maybeAddImport("java.security.SecureRandom");
                List existingStatements = cd.getBody().getStatements();
                List reorderedStatements = Stream.concat(existingStatements.subList(existingStatements.size() - 3, existingStatements.size()).stream(), existingStatements.subList(0, existingStatements.size() - 3).stream()).collect(Collectors.toList());
                cd = cd.withBody(cd.getBody().withStatements(reorderedStatements));
                String randomStringUtilsFqn = this.getCursor().pollMessage(FixCwe338.COMMONS_LANG_2) == null ? "org.apache.commons.lang3.RandomStringUtils" : "org.apache.commons.lang.RandomStringUtils";
                this.maybeAddImport(randomStringUtilsFqn);
                this.doAfterVisit((TreeVisitor)new AutoFormatVisitor());
                return cd;
            }

            public J.Import visitImport(J.Import _import, ExecutionContext ctx) {
                if ("org.apache.commons.lang".equals(_import.getPackageName())) {
                    this.getCursor().putMessage(FixCwe338.COMMONS_LANG_2, (Object)true);
                }
                return _import;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, ExecutionContext ctx) {
                return (J.MethodInvocation)JavaTemplate.builder((String)"generateRandomAlphanumericString()").contextSensitive().javaParser(JAVA_PARSER).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[0]);
            }
        });
    }
}

