/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.Tree;
import org.openrewrite.kubernetes.tree.KubernetesModel;
import org.openrewrite.marker.Marker;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class RefreshModel<P>
extends YamlIsoVisitor<P> {
    private static final Pattern METADATA_LABEL = Pattern.compile("/metadata/labels/(.+)");
    private static final Pattern METADATA_ANNOTATION = Pattern.compile("/metadata/annotations/(.+)");

    public Yaml.Document visitDocument(Yaml.Document document, P p) {
        Yaml.Document d = super.visitDocument(document, p);
        KubernetesModel resource = new KubernetesModel(Tree.randomId(), (String)this.getCursor().getMessage("apiVersion"), (String)this.getCursor().getMessage("kind"), new KubernetesModel.Metadata((String)this.getCursor().getMessage("namespace"), (String)this.getCursor().getMessage("name"), (Map)this.getCursor().getMessage("annotations"), (Map)this.getCursor().getMessage("labels")));
        return d.withMarkers(document.getMarkers().computeByType((Marker)resource, (old, n) -> n));
    }

    public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, P p) {
        String path = this.getPath();
        if (entry.getValue() instanceof Yaml.Scalar) {
            String value = ((Yaml.Scalar)entry.getValue()).getValue();
            switch (path) {
                case "/apiVersion": {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, "apiVersion", (Object)value);
                    break;
                }
                case "/kind": {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, "kind", (Object)value);
                    break;
                }
                case "/metadata/namespace": {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, "namespace", (Object)value);
                    break;
                }
                case "/metadata/name": {
                    this.getCursor().putMessageOnFirstEnclosing(Yaml.Document.class, "name", (Object)value);
                }
            }
            Matcher label = METADATA_LABEL.matcher(path);
            if (label.matches()) {
                ((HashMap)this.getCursor().dropParentUntil(Yaml.Document.class::isInstance).computeMessageIfAbsent("labels", l -> new HashMap())).put(label.group(1), value);
            } else {
                Matcher annotation = METADATA_ANNOTATION.matcher(path);
                if (annotation.matches()) {
                    ((HashMap)this.getCursor().dropParentUntil(Yaml.Document.class::isInstance).computeMessageIfAbsent("annotations", a -> new HashMap())).put(annotation.group(1), value);
                }
            }
        }
        return super.visitMappingEntry(entry, p);
    }

    private String getPath() {
        return "/" + this.getCursor().getPathAsStream().filter(p -> p instanceof Yaml.Mapping.Entry).map(Yaml.Mapping.Entry.class::cast).map(e -> e.getKey().getValue()).reduce("", (a, b) -> b + (a.isEmpty() ? "" : "/" + a));
    }
}

