/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kubernetes.Kubernetes;
import org.openrewrite.kubernetes.RefreshModel;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.tree.Yaml;

public final class KubernetesParser
implements Parser<Kubernetes> {
    YamlParser yamlParser = new YamlParser();

    private KubernetesParser() {
    }

    public List<Kubernetes> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public List<Kubernetes> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.yamlParser.parseInputs(sources, relativeTo, ctx).stream().map(yaml -> this.toKubernetes((Yaml.Documents)yaml, ctx)).collect(Collectors.toList());
    }

    public boolean accept(Path path) {
        return this.yamlParser.accept(path);
    }

    public static Builder builder() {
        return new Builder();
    }

    private Kubernetes toKubernetes(Yaml.Documents yaml, ExecutionContext ctx) {
        Yaml.Documents y = (Yaml.Documents)new RefreshModel().visit((Tree)yaml, ctx);
        assert (y != null);
        return new Kubernetes(y);
    }

    public static class Builder {
        public KubernetesParser build() {
            return new KubernetesParser();
        }
    }
}

