/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.kubernetes.Kubernetes;
import org.openrewrite.kubernetes.KubernetesVisitor;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.RecipeSearchResult;
import org.openrewrite.yaml.search.FindKey;
import org.openrewrite.yaml.tree.Yaml;

public final class FindResourceMissingConfiguration
extends Recipe {
    @Option(displayName="Resource kind", description="The Kubernetes resource type to search on.", example="Pod")
    private final String resourceKind;
    @Option(displayName="Configuration path", description="An XPath expression to locate Kubernetes configuration.", example="/spec/containers/livenessProbe")
    private final String configurationPath;

    public String getDisplayName() {
        return "Missing configuration";
    }

    public String getDescription() {
        return "Find Kubernetes resources with missing configuration.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KubernetesVisitor<ExecutionContext>(){

            @Override
            public Kubernetes.ResourceDocument visitKubernetes(Kubernetes.ResourceDocument resource, ExecutionContext executionContext) {
                return FindResourceMissingConfiguration.this.resourceKind.equals(resource.getModel().getKind()) && FindKey.find((Yaml)resource, (String)FindResourceMissingConfiguration.this.configurationPath).isEmpty() ? resource.withMarkers(resource.getMarkers().addIfAbsent((Marker)new RecipeSearchResult(Tree.randomId(), (Recipe)FindResourceMissingConfiguration.this))) : resource;
            }
        };
    }

    public FindResourceMissingConfiguration(String resourceKind, String configurationPath) {
        this.resourceKind = resourceKind;
        this.configurationPath = configurationPath;
    }

    public String getResourceKind() {
        return this.resourceKind;
    }

    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public String toString() {
        return "FindResourceMissingConfiguration(resourceKind=" + this.getResourceKind() + ", configurationPath=" + this.getConfigurationPath() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindResourceMissingConfiguration)) {
            return false;
        }
        FindResourceMissingConfiguration other = (FindResourceMissingConfiguration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$resourceKind = this.getResourceKind();
        String other$resourceKind = other.getResourceKind();
        if (this$resourceKind == null ? other$resourceKind != null : !this$resourceKind.equals(other$resourceKind)) {
            return false;
        }
        String this$configurationPath = this.getConfigurationPath();
        String other$configurationPath = other.getConfigurationPath();
        return !(this$configurationPath == null ? other$configurationPath != null : !this$configurationPath.equals(other$configurationPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindResourceMissingConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $resourceKind = this.getResourceKind();
        result = result * 59 + ($resourceKind == null ? 43 : $resourceKind.hashCode());
        String $configurationPath = this.getConfigurationPath();
        result = result * 59 + ($configurationPath == null ? 43 : $configurationPath.hashCode());
        return result;
    }
}

